% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterD3.R
\name{scatterD3}
\alias{scatterD3}
\title{Scatter plot HTML widget}
\source{
D3.js was created by Michael Bostock. See \url{http://d3js.org/}
}
\usage{
scatterD3(x, y, lab = NULL, point_size = 64, labels_size = 10,
  point_opacity = 1, fixed = FALSE, col_var = NULL, colors = NULL,
  symbol_var = NULL, size_var = NULL, size_range = c(10, 300),
  col_lab = NULL, symbol_lab = NULL, size_lab = NULL, key_var = NULL,
  type_var = NULL, unit_circle = FALSE, tooltips = TRUE,
  tooltip_text = NULL, xlab = NULL, ylab = NULL, html_id = NULL,
  width = NULL, height = NULL, legend_width = 150, xlim = NULL,
  ylim = NULL, dom_id_reset_zoom = "scatterD3-reset-zoom",
  dom_id_svg_export = "scatterD3-svg-export", transitions = FALSE)
}
\arguments{
\item{x}{numerical vector of x values}

\item{y}{numerical vector of y values}

\item{lab}{optional character vector of text labels}

\item{point_size}{points size. Ignored if size_var is not NULL.}

\item{labels_size}{text labels size}

\item{point_opacity}{points opacity}

\item{fixed}{force a 1:1 aspect ratio}

\item{col_var}{optional vector for points color mapping}

\item{colors}{vector of custom points colors. Colors must be
defined as an hexadecimal string (eg "#FF0000").  If
\code{colors} is a named list or vector, then the colors will
be associated with their name within \code{col_var}.}

\item{symbol_var}{optional vector for points symbol mapping}

\item{size_var}{optional vector for points size mapping}

\item{size_range}{numeric vector of length 2, giving the minimum and maximum point sizes when mapping with size_var}

\item{col_lab}{color legend title}

\item{symbol_lab}{symbols legend title}

\item{size_lab}{size legend title}

\item{key_var}{optional vector of rows ids. This is passed as a key to d3, and is only added in shiny apps where displayed rows are filtered interactively.}

\item{type_var}{optional vector of points type : "point" for adot (default), "arrow" for an arrow starting from the origin.}

\item{unit_circle}{set tot TRUE to draw a unit circle}

\item{tooltips}{logical value to display tooltips when hovering points}

\item{tooltip_text}{optional character vector of tooltips text}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{html_id}{manually specify an HTML id for the svg root node. A random one is generated by default.}

\item{width}{figure width, computed when displayed}

\item{height}{figure height, computed when displayed}

\item{legend_width}{legend area width, in pixels}

\item{xlim}{numeric vector of length 2, manual x axis limits}

\item{ylim}{numeric vector of length 2, manual y axis limits}

\item{dom_id_reset_zoom}{HTML DOM id of the element to bind the "reset zoom" control to.}

\item{dom_id_svg_export}{HTML DOM id of the element to bind the "svg export" control to.}

\item{transitions}{if TRUE, data updates are displayed with smooth transitions, if FALSE the whole chart is redrawn. Only used within shiny apps.}
}
\description{
Generates an interactive scatter plot based on d3.js.
Interactive features include zooming, panning, text labels moving, tooltips,
fading effects in legend. Additional handlers are provided to change label
size, point opacity or export the figure as an SVG file via HTML form controls.
}
\details{
Interactive scatter plots based on htmlwidgets and d3.js
}
\examples{
scatterD3(x = mtcars$wt, y = mtcars$mpg, lab = rownames(mtcars),
          col_var = mtcars$cyl, symbol_var = mtcars$am,
          xlab = "Weight", ylab = "Mpg", col_lab = "Cylinders",
          symbol_lab = "Manual transmission", html_id = NULL)

}
\author{
Julien Barnier <julien.barnier@ens-lyon.fr>
}

