% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createEmb.r
\name{createEmb}
\alias{createEmb}
\title{Create multiple dimension reduction embeddings}
\usage{
createEmb(
  dr_input,
  n_runs = 100,
  method = c("umap", "tsne"),
  n_neighbors = 15,
  min_dist = 0.1,
  perplexity = 30,
  theta = 0.5,
  n_cores = 1,
  seeds = NULL
)
}
\arguments{
\item{dr_input}{A numeric matrix or data frame containing the input data for dimension
reduction, with rows representing observations (cells) and columns representing
PCA components}

\item{n_runs}{Integer specifying the number of embeddings to generate (default: 100)}

\item{method}{Character string specifying the dimension reduction method to use:
either "umap" or "tsne"}

\item{n_neighbors}{Integer specifying the number of neighbors to consider when constructing the
initial graph (used for UMAP only, default: 30)}

\item{min_dist}{Numeric value specifying the minimum distance between points in the embedding
(used for UMAP only, default: 0.1)}

\item{perplexity}{Numeric value controlling the effective number of neighbors
(used for t-SNE only, default: 30)}

\item{theta}{Numeric value between 0 and 1 controlling the speed/accuracy trade-off
(used for t-SNE only, default: 0.5)}

\item{n_cores}{Integer specifying the number of CPU cores to use for parallelization (default: 1)}

\item{seeds}{A set of seeds of length n_runs to be used for each embedding}
}
\value{
A list of dimension reduction embeddings, each represented as a data frame
with rows corresponding to observations (cells) and two columns representing the
x and y coordinates in the reduced space.
}
\description{
Generates multiple dimension reduction embeddings using either UMAP or t-SNE algorithms. Each embedding is created with different random initializations to assess stability. The function returns a list of embeddings, each represented as a data frame or matrix.
}
