% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareEmb.r
\name{compareEmb}
\alias{compareEmb}
\title{Compare dimensional reduction embeddings and calculate stability statistics}
\usage{
compareEmb(emb_list, n_cores = 1, verbose = TRUE, print_plot = TRUE)
}
\arguments{
\item{emb_list}{A list of 2D embeddings (each typically containing coordinates for UMAP or t-SNE)
created by the \code{createEmb} function}

\item{n_cores}{Integer specifying the number of CPU cores to use for parallelization (default: 1)}

\item{verbose}{Whether the function should print summary statistics as it calculates them}

\item{print_plot}{Whether the final violin plot should be automatically printed}
}
\value{
A list containing the following components:
\item{mean}{Numeric value representing the overall mean correlation across all pairwise comparisons}
\item{mean_per_embedding}{Numeric vector of mean correlation values for each embedding}
\item{all_pairwise_correlations}{Numeric vector containing all pairwise correlation values}
\item{range}{Numeric vector with minimum and maximum of mean correlation per embedding}
\item{ci}{Numeric vector containing the lower and upper bounds of the 95\% confidence interval}
}
\description{
Evaluates the stability of a set of dimension reduction embeddings by performing
pairwise Procrustes alignment and calculating Kendall's Tau correlation between
each pair. This function quantifies the consistency of embeddings generated with
the same algorithm but different random initializations.
}
