% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_Utilities_Seurat.R
\name{exAM_Scoring}
\alias{exAM_Scoring}
\title{Add exAM Gene List Module Scores}
\usage{
exAM_Scoring(
  seurat_object,
  species,
  exam_module_name = NULL,
  method = "Seurat",
  ensembl_ids = FALSE,
  assay = NULL,
  overwrite = FALSE,
  exclude_unfound = FALSE,
  seed = 1
)
}
\arguments{
\item{seurat_object}{object name.}

\item{species}{Species of origin for given Seurat Object.  Only accepted species are: mouse, human (name or abbreviation).}

\item{exam_module_name}{name to use for the new meta.data column containing module scores.}

\item{method}{method to use for module scoring, currently only "Seurat" is supported but more to be added.  .}

\item{ensembl_ids}{logical, whether feature names in the object are gene names or
ensembl IDs (default is FALSE; set TRUE if feature names are ensembl IDs).}

\item{assay}{Assay to use (default is the current object default assay).}

\item{overwrite}{Logical.  Whether to overwrite existing meta.data columns.  Default is FALSE meaning that
function will abort if columns with the name provided to \code{exam_module_name} is present in meta.data slot.}

\item{exclude_unfound}{logical, whether to exclude features not present in current object (default is FALSE).}

\item{seed}{seed for reproducibility (default is 1).}
}
\value{
Seurat object
}
\description{
Adds module scores from exAM genes from mouse and human.
}
\examples{
\dontrun{
# Seurat
seurat_object <- exAM_Scoring(seurat_object = seurat_object, species = "human")
}

}
\references{
Gene list is from: SI Table 22 Marsh et al., 2022 (Nature Neuroscience) from \doi{10.1038/s41593-022-01022-8}.
See data-raw directory for scripts used to create gene list.
}
\concept{qc_util}
