% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat_Iterative.R
\name{Iterate_DimPlot_bySample}
\alias{Iterate_DimPlot_bySample}
\title{Iterate DimPlot By Sample}
\usage{
Iterate_DimPlot_bySample(
  seurat_object,
  sample_column = "orig.ident",
  file_path = NULL,
  file_name = NULL,
  file_type = NULL,
  single_pdf = FALSE,
  output_width = NULL,
  output_height = NULL,
  dpi = 600,
  color = "black",
  no_legend = TRUE,
  title_prefix = NULL,
  reduction = NULL,
  dims = c(1, 2),
  pt.size = NULL,
  raster = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{sample_column}{name of meta.data column containing sample names/ids (default is "orig.ident").}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{name suffix to append after sample name.}

\item{file_type}{File type to save output as.  Must be one of following: ".pdf", ".png", ".tiff", ".jpeg", or ".svg".}

\item{single_pdf}{saves all plots to single PDF file (default = FALSE).  `file_type`` must be .pdf}

\item{output_width}{the width (in inches) for output page size.  Default is NULL.}

\item{output_height}{the height (in inches) for output page size.  Default is NULL.}

\item{dpi}{dpi for image saving.}

\item{color}{color scheme to use.}

\item{no_legend}{logical, whether or not to include plot legend, default is TRUE.}

\item{title_prefix}{Value that should be used for plot title prefix if \code{no_legend = TRUE}.
If NULL the value of \code{meta_data_column} will be used.  Default is NULL.}

\item{reduction}{Dimensionality Reduction to use (default is object default).}

\item{dims}{Dimensions to plot.}

\item{pt.size}{Adjust point size for plotting.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{DimPlot}}.}
}
\value{
A ggplot object
}
\description{
Iterate DimPlot by orig.ident column from Seurat object metadata
}
\examples{
\dontrun{
Iterate_DimPlot_bySample(seurat_object = object, file_path = "plots/", file_name = "tsne",
file_type = ".jpg", dpi = 600, color = "black")
}

}
\concept{iterative_plotting}
