% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.R
\name{fisheries_matrices}
\alias{fisheries_matrices}
\title{fisheries_matrices}
\usage{
fisheries_matrices(
  states = 0:20,
  actions = states,
  observed_states = states,
  reward_fn = function(x, a) pmin(x, a),
  f = ricker(1, 15),
  sigma_g = 0.1,
  sigma_m = 0.1,
  noise = c("rescaled-lognormal", "lognormal", "uniform", "normal")
)
}
\arguments{
\item{states}{sequence of possible states}

\item{actions}{sequence of possible actions}

\item{observed_states}{sequence of possible observations}

\item{reward_fn}{function of x and a that gives reward for tacking action a when state is x}

\item{f}{transition function of state x and action a.}

\item{sigma_g}{half-width of uniform shock or equivalent variance for log-normal}

\item{sigma_m}{half-width of uniform shock or equivalent variance for log-normal}

\item{noise}{distribution for noise, "lognormal" or "uniform"}
}
\value{
list of transition matrix, observation matrix, and reward matrix
}
\description{
Initialize the transition, observation, and reward matrices given
 a transition function, reward function, and state space
}
\details{
assumes log-normally distributed observation errors and process errors
}
\examples{
m <- fisheries_matrices()
}
