% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_data_classes.R
\docType{class}
\name{sfn_data-class}
\alias{sfn_data-class}
\alias{sfn_data}
\title{S4 class for sapfluxnet site data}
\description{
Main class for storing sapfluxnet project site data and metadata
}
\details{
This class allows to store all the data and metadata for a sapfluxnet site
in one single object, to easily work with it. See
\code{vignette('sfn-data-classes', package = 'sapfluxnetr')} for more info.
}
\section{Slots}{

\describe{
\item{\code{sapf_data}}{A data frame with the sapf data}

\item{\code{env_data}}{A data frame with the env data}

\item{\code{sapf_flags}}{A data frame with the same dimensions of \code{sapf_data}
with the flag info for each tree/TIMESTAMP combination}

\item{\code{env_flags}}{A data frame with the same dimensions of \code{env_data} with
the flag info for each env_var/TIMESTAMP combination}

\item{\code{si_code}}{A character vector of length one indicating
the site code}

\item{\code{timestamp}}{A POSIXct vector of length \code{nrow(sapf_data)} with the
timestamp}

\item{\code{solar_timestamp}}{A POSIXct vector of length \code{nrow(sapf_data)} with
the solar timestamp}

\item{\code{site_md}}{A data frame containing the site metadata}

\item{\code{stand_md}}{A data frame containing the stand metadata}

\item{\code{species_md}}{A data frame containing the species metadata}

\item{\code{plant_md}}{A data frame containing the plant metadata}

\item{\code{env_md}}{A data frame containing the env metadata}
}}

