% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikF}
\alias{llikF}
\title{log likelihood and derivatives for F distribution}
\usage{
llikF(x, df1, df2, full = FALSE)
}
\arguments{
\item{x}{variable that is distributed by f distribution}

\item{df1, df2}{degrees of freedom.  \code{Inf} is allowed.}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with \code{dDf1} and \code{dDf2}
that has the derivatives with respect to the \code{df1}/\code{df2} parameters at
the observation time-point
}
\description{
log likelihood and derivatives for F distribution
}
\examples{

x <- seq(0.001, 5, length.out = 100)

llikF(x^2, 1, 5)

}
\author{
Matthew L. Fidler
}
