% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Alor.R
\name{getSymbols.Alor}
\alias{getSymbols.Alor}
\title{Download Alor data}
\usage{
getSymbols.Alor(
  Symbols,
  env = globalenv(),
  from = "2007-01-01",
  to = Sys.Date(),
  adjust = FALSE,
  api.key = NULL,
  period = "day",
  verbose = TRUE,
  board = "MOEX",
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{a character vector of Alor symbols to download data for.}

\item{env}{environment where to create the downloaded data object.}

\item{from}{a character string indicating the start date of the data to download, in YYYY-MM-DD format.}

\item{to}{a character string indicating the end date of the data to download, in YYYY-MM-DD format.}

\item{adjust}{a logical indicating whether to adjust the data for stock splits or not.}

\item{api.key}{an Alor API key.}

\item{period}{a character string indicating the frequency of the data to download. Possible values are '1min', '5min', 'hour', 'day', 'week', and 'month'.}

\item{verbose}{a logical indicating whether to print the response details or not.}

\item{board}{a character string indicating the Alor exchange board to use. Possible values are 'MOEX' and 'SPB'.}

\item{auto.assign}{a logical indicating whether to automatically assign the downloaded data to the global environment.}

\item{...}{additional arguments passed to getSymbols.Alor}
}
\value{
returns an data.table object containing financial data
}
\description{
Download historical market data from Alor for a given symbol and time range.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getSymbols.Alor('SBER',from = '2023-04-01',to='2023-05-04',period = '1min')
getSymbols('SBER',src='Alor')
}
\author{
Vyacheslav Arbuzov
}
