% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/placeOrder.R
\name{placeOrder}
\alias{placeOrder}
\title{Place an order on a broker/exchange platform}
\usage{
placeOrder(
  src = "tinkoff",
  symbol = "SBER",
  board = "MOEX",
  action = "BUY",
  orderType = "LMT",
  totalQuantity = "10",
  lmtPrice = "100",
  auxPrice = "",
  api.key = "",
  live = TRUE,
  tif = "",
  orderId = "",
  clientId = "",
  verbose = TRUE
)
}
\arguments{
\item{src}{A character string indicating the broker/exchange. Currently supported sources are 'tinkoff', 'finam', and 'alor'.}

\item{symbol}{A character string indicating the security symbol.}

\item{board}{A character string indicating the exchange board.}

\item{action}{A character string indicating the action to perform. Possible values are 'BUY' and 'SELL'.}

\item{orderType}{A character string indicating the type of order. Possible values are 'LMT' (limit) and 'MKT' (market).}

\item{totalQuantity}{A character string or numeric value indicating the quantity of securities to order.}

\item{lmtPrice}{A character string or numeric value indicating the limit price for the order.}

\item{auxPrice}{A character string or numeric value indicating the auxiliary price for the order. This parameter is only used when orderType is 'STP' (stop).}

\item{api.key}{A character string indicating the API key to use for authentication with the broker/exchange.}

\item{live}{A logical value indicating whether to place a live (real) order or a test (paper) order.}

\item{tif}{A character string indicating the time-in-force of the order. Possible values are 'DAY', 'GTC' (good till cancel), and 'IOC' (immediate or cancel).}

\item{orderId}{A character string indicating the order ID to use. If empty, a random ID is generated.}

\item{clientId}{A character string indicating the client ID to use.}

\item{verbose}{A logical value indicating whether to print verbose output.}
}
\value{
A list with the result of the order placement.
}
\description{
This function place an existing order on a specified broker or exchange platform
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
myorder = placeOrder(src = 'alor',
                     symbol = 'MTLR-6.23',
                     board = 'MOEX',
                     action = 'BUY',
                     orderType = 'LMT',
                     totalQuantity = 1,
                     lmtPrice = 20000,
                     api.key = '',
                     clientId = 'cliendID')
}
