% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_huiwalter.R
\name{template_huiwalter}
\alias{template_huiwalter}
\title{Create a Hui-Walter model based on paired test data for an arbitrary number of tests and populations}
\usage{
template_huiwalter(
  testdata,
  outfile = "huiwalter_model.txt",
  covariance = FALSE,
  se_priors = "dbeta(1,1)",
  sp_priors = "dbeta(1,1)"
)
}
\arguments{
\item{testdata}{the input paired test data, where each column name corresponds to a test result - except possibly "ID" which is ignored, and "Population" indicating a population identifier for that row. Each row must represent test results from the same individual either as logical or a factor with two levels (and where the first level indicates a negative test result). Data may be missing at random (except for Population).}

\item{outfile}{the name of the text file to save the model representation}

\item{covariance}{should covariance terms be activated or omitted?}

\item{se_priors}{the priors to use for sensitivity parameters (can be adjusted in the model once it is generated)}

\item{sp_priors}{the priors to use for specificity parameters (can be adjusted in the model once it is generated)}
}
\description{
Create a Hui-Walter model based on paired test data for an arbitrary number of tests and populations
}
