% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tasks.R
\name{add_task_in_project}
\alias{add_task_in_project}
\title{Add task in project}
\usage{
add_task_in_project(
  project_id,
  task,
  try_again = 3,
  time_try_again = 3,
  verbose = TRUE,
  responsible = NULL,
  token = get_todoist_api_token(),
  exiting_tasks = get_tasks(token = token)
)
}
\arguments{
\item{project_id}{id of a project}

\item{task}{a task}

\item{try_again}{start again the request}

\item{time_try_again}{number of tries}

\item{verbose}{make it talk}

\item{responsible}{add people in project with email. To know user email, use \code{\link{get_users}}.}

\item{token}{token}

\item{exiting_tasks}{list of tasks already in the project}
}
\value{
project id
}
\description{
To work, it needs a project id.
}
\examples{
\dontrun{
add_project("my_proj") \%>\%
   add_task_in_project("Add tasks")
}
}
