% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clo.R
\name{indivCloPlots}
\alias{indivCloPlots}
\title{Produces plots of either an uncoupled or coupled oscillator model-predicted trajectories overlaid on raw data for each dyad.}
\usage{
indivCloPlots(
  derivData,
  whichModel,
  idConvention,
  dist0name = NULL,
  dist1name = NULL,
  plot_obs_name = NULL,
  minMax = NULL,
  printPlots = T
)
}
\arguments{
\item{derivData}{A dataframe that was produced with the "estDerivs" function.}

\item{whichModel}{Whether the model to be estimated is the "uncoupled" or "coupled" oscillator.}

\item{idConvention}{The number that was added to the dist0 partner to get the ID number for the dist1 partner.}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable (e.g., "Women"). Default is dist0.}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable (e.g., "Men"). Default is dist1.}

\item{plot_obs_name}{An optional name for the observed state variables being plotted (e.g., "Emotional Experience"). Default is observed.}

\item{minMax}{An optional vector with desired minimum and maximum quantiles to be used for setting the y-axis range on the plots, e.g., minMax <- c(.1, .9) would set the y-axis limits to the 10th and 90th percentiles of the observed state variables. Default is to use the minimum and maximum observed values of the state variables.}

\item{printPlots}{If true (the default) plots are displayed on the screen.}
}
\value{
A list plots of the predicted values against the observed values for each dyad.
}
\description{
The observed and CLO-model predicted state variables (with linear trends removed) are plotted for each dyad individually.
}
\examples{
# See vignettes for examples.

}
