% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/os_legislatorsearch.R
\name{os_legislatorsearch}
\alias{os_legislatorsearch}
\title{Search Legislators on OpenStates.}
\usage{
os_legislatorsearch(state = NULL, first_name = NULL, last_name = NULL,
  chamber = NULL, active = NULL, term = NULL, district = NULL,
  party = NULL, fields = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{state}{state two-letter abbreviation (character)}

\item{first_name}{first name of legislator (character)}

\item{last_name}{last name of legislator (character)}

\item{chamber}{one of 'upper' or 'lower' (character)}

\item{active}{TRUE or FALSE (character)}

\item{term}{filter by legislators who served during a certain term (character)}

\item{district}{legislative district (character)}

\item{party}{democratic or republican (character)}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{as}{(character) One of table (default), list, or response (httr response object)}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
List of output fields.
}
\description{
Search Legislators on OpenStates.
}
\examples{
\dontrun{
os_legislatorsearch(state = 'ca', party = 'democratic')
os_legislatorsearch(state = 'tx', party = 'democratic', active = TRUE)
os_legislatorsearch(state = 'nv', party = 'republican')
os_legislatorsearch(state = 'dc', chamber = 'upper')

# pass in more than one value for some parameters
os_legislatorsearch(state = c('dc', 'or'), chamber = 'upper')
os_legislatorsearch(first_name = c('jane', 'bob'), chamber = 'upper')
}
}

