% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_contr}
\alias{ie_contr}
\title{Search for itemized campaign contributions}
\usage{
ie_contr(amount = NULL, contributor_ft = NULL, contributor_state = NULL,
  cycle = NULL, date = NULL, for_against = NULL, organization_ft = NULL,
  recipient_ft = NULL, recipient_state = NULL, seat = NULL,
  transaction_namespace = NULL, page = NULL, per_page = NULL,
  return = "table", key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{amount}{The amount of the contribution in US dollars in one of the following formats:
500 (exactly 500 dollars), >|500 (greater than or equal to 500 dollars), <|500 (less than or
equal to 500 dollars)}

\item{contributor_ft}{Full-text search on name of individual, PAC, organization, or employer.}

\item{contributor_state}{Two-letter abbreviation of state from which the contribution was made.}

\item{cycle}{A YYYY formatted year (1990 - 2010) as a single year or YYYY|YYYY for an OR logic.}

\item{date}{date of the contribution in ISO date format (with ><|2006-08-06|2006-09-12 as a
between-dates search).}

\item{for_against}{Either \dQuote{for} or \dQuote{against}. When organizations run ads against
a candidate, they are counted as independent expenditures with the candidate as the recipient.
This parameter can be used to filter contributions meant for the candidate and those meant to
be against the candidate.}

\item{organization_ft}{Full-text search on employer, organization, and parent organization.}

\item{recipient_ft}{Full-text search on name of PAC or candidate receiving the contribution.}

\item{recipient_state}{Two-letter abbreviation of state in which the candidate receiving the
contribution is running.}

\item{seat}{Type of office being sought: \dQuote{federal:senate}, \dQuote{federal:house},
\dQuote{federal:president}, \dQuote{state:upper}, \dQuote{state:lower}, or
\dQuote{state:governor}. Use a pipe to separate multiple offices for an OR logic.}

\item{transaction_namespace}{Filters on federal or state contributions:
\dQuote{urn:fec:transaction} (federal) or \dQuote{urn:nimsp:transaction} (state).}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}
}
\value{
Details on campaign contributions.
}
\description{
Search for itemized campaign contributions at the federal (FEC) or state (NIMSP) level.
}
\examples{
\dontrun{
ie_contr(amount='<|100')
ie_contr(amount='<|100', page=1, per_page=3)
ie_contr(recipient_state='al', for_against='for', amount='<|20')
}
}

