% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_node_edge_df_hd.R
\name{create_node_edge_df_hd}
\alias{create_node_edge_df_hd}
\title{Create dataframe of node and aggregated edge embeddings for high dimensional feature networks}
\usage{
create_node_edge_df_hd(embeddings_data, function_names = c("mean", "median"))
}
\arguments{
\item{embeddings_data}{A list. The output of any of the setse embedding functions}

\item{function_names}{A string vector. the names of the aggregation methods to be used}
}
\value{
A dataframe with node names, node force, node elevation and strain and tension aggregated using the named functions.
The strain and tension columns are returned with names in the form "strain_x" where "x" is the name of the function used 
to aggregate. The total number of columns is dependent on the number of aggregation functions.
}
\description{
Aggregates edge strain and tension to node level
}
\details{
Often if can be useful to have edge data at node level, an example of this would be plotting
the node and tension or strain. To do this requires that the edge embeddings are aggregated somehow to node level
and joined to the appropriate node. This function takes as an argument the output of the setse embedding functions
and any number of aggregation functions to produce a dataframe that is convenient to use.
}
\examples{

g <- biconnected_network \%>\%
 prepare_edges(.) \%>\%
 #prepare the continuous features as normal
 prepare_continuous_force(., node_names = "name", force_var = "force") \%>\%
 #prepare the categorical features as normal
 prepare_categorical_force(., node_names = "name", force_var = "group")
  
 #embed them using the high dimensional function
 two_dimensional_embeddings <- setse_auto_hd(g, force = c("group_A", "force"), k = "weight")

 out <- create_node_edge_df_hd(two_dimensional_embeddings , 
  function_names = c("mean", "mode", "sum"))

}
