% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{sc_select}
\alias{sc_select}
\alias{sc_select_}
\title{Select scorecard data variables.}
\usage{
sc_select(sccall, ...)

sc_select_(sccall, vars)
}
\arguments{
\item{sccall}{Current list of parameters carried forward from prior
functions in the chain (ignore)}

\item{...}{Desired variable names separated by commas (not case sensitive)}

\item{vars}{Character string of variable name or vector of
character string variable names}
}
\description{
This function is used to select the variables returned in the final dataset.
}
\section{Functions}{
\itemize{
\item \code{sc_select_()}: Standard evaluation version of
\code{\link{sc_select}} (\code{vars} must be string or vector
of strings when using this version)

}}
\examples{
\dontrun{
sc_select(UNITID)
sc_select(UNITID, INSTNM)
sc_select(unitid, instnm)
}
\dontrun{
sc_select_('UNITID')
sc_select_(c('UNITID', 'INSTNM'))
sc_select_(c('unitid', 'instnm'))

## stored in object
vars_to_pull <- c('unitid','instnm')
sc_select(vars_to_pull)
}

}
