% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrepast-parallel.R
\name{ParallelRun}
\alias{ParallelRun}
\title{ParallelRun}
\usage{
ParallelRun(modeldir, datasource, maxtime, r = 1, seed = c(),
  design = NULL, default = NULL)
}
\arguments{
\item{modeldir}{The installation directory of some repast model}

\item{datasource}{The name of any model aggregate dataset}

\item{maxtime}{The total simulated time}

\item{r}{The number of experiment replications}

\item{seed}{The random seed collection}

\item{design}{The desing matrix holding parameter sampling}

\item{default}{The alternative values for parameters which should be kept fixed}
}
\value{
The model output dataset
}
\description{
Run simulations in parallel. This function 
executes the time steps of an instantiated model. The number 
of replications of model runs can be specified by the 
function parameter. The seed parameter may be 
omitted and will be generated internally. If provided, 
the seed collection, must contain the same
number of \code{r} parameter.
}
\examples{
\dontrun{
   md<- "/usr/models/your-model-directory"
   output<- ParallelRun(modeldir= md, maxtime = 360, dataset= ds, r=4)} 

}
