% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Testfunction.R
\name{test.smoother}
\alias{test.smoother}
\title{Test how well a smoother can filter noise from data}
\usage{
test.smoother(n = 1, m = 5, incr = 1, max = 20, smoother,
  pattern = TRUE, ntype = "white", ...)
}
\arguments{
\item{n}{number of runs}

\item{m}{number of runs per level of noise}

\item{incr}{value by which the error is increased in each turn}

\item{max}{max number of times the error is increased}

\item{smoother}{Function with pre-defined inputs, so that only the parameter \code{input} is left to be defined}

\item{pattern}{Check whether pattern was recognised. If \code{FALSE} only the correct position of extrema is checked.}

\item{ntype}{Noise type. See \code{noise} function for details.}

\item{...}{other parameters the smoother requires}
}
\value{
Vector of recognition rates for specified levels of noise
}
\description{
Use this function to find out about the rate of successful recognition of a simple HS pattern for any smoothing function
of your choice. Speciffy the noise and other testing conditions.
}
\details{
For an overview of the package capabilities, click here \link{rpatrec}.
Note that this function may be extremely computationally demanding.
}
\examples{
\dontrun{
#Test the kernel regression smoother
a <- test.smoother(n=5,m=10,incr=0.5,max=50,smoother = kernel,bandwidth=1)
#Plot the result
plot(a,type='l')
}

}
