% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellation.R
\name{get_role_playing_dimension_names}
\alias{get_role_playing_dimension_names}
\alias{get_role_playing_dimension_names.star_database}
\title{Get the names of the role playing dimensions}
\usage{
get_role_playing_dimension_names(db)

\method{get_role_playing_dimension_names}{star_database}(db)
}
\arguments{
\item{db}{A \code{constellation} object.}
}
\value{
A list of vector of strings with dimension names.
}
\description{
Role playing dimensions are defined in star_databases. When integrating
several star_databases to form a constellation, role playing dimensions are
also integrated. This function allows you to see the result.
}
\examples{

db1 <- star_database(mrs_cause_schema_rpd, ft_cause_rpd) |>
  role_playing_dimension(
    rpd = "When",
    roles = c("When Available", "When Received")
  )

db2 <- star_database(mrs_age_schema_rpd, ft_age_rpd) |>
  role_playing_dimension(
    rpd = "When Arrived",
    roles = c("When Available")
  )
rpd <- constellation("MRS", db1, db2) |>
  get_role_playing_dimension_names()

}
\seealso{
\code{\link{star_schema}}, \code{\link{flat_table}}

Other star database definition functions: 
\code{\link{get_dimension_names}()},
\code{\link{get_dimension_table}()},
\code{\link{get_fact_names}()},
\code{\link{get_table_names}()},
\code{\link{group_dimension_instances}()},
\code{\link{role_playing_dimension}()},
\code{\link{star_database}()}
}
\concept{star database definition functions}
