% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{deploy}
\alias{deploy}
\alias{deploy.star_database}
\title{Deploy a star database in a relational database}
\usage{
deploy(db, name, connect, disconnect, file)

\method{deploy}{star_database}(db, name, connect, disconnect = NULL, file = NULL)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{name}{A string, name of the deployment.}

\item{connect}{A function that returns a \code{DBI::DBIConnection} object.}

\item{disconnect}{A function that receives a \code{DBI::DBIConnection} object as a
parameter and close the connection.}

\item{file}{A string, name of the file to store the object.}
}
\value{
A \code{star_database} object.
}
\description{
To deploy the star database, we must indicate a name for the deployment, a
connection function and a disconnection function from the database. If it is
the first deployment, we must also indicate the name of a local file where the
star database will be stored.
}
\details{
If the disconnection function consists only of calling \code{DBI::dbDisconnect(con)},
there is no need to indicate it, it is taken by default.

As a result, it exports the tables from the star database to the connection
database and from now on will keep them updated with each periodic refresh.
Additionally, it will also keep a copy of the star database updated on file,
which can be used when needed.
}
\examples{

mrs_rdb_file <- tempfile("mrs", fileext = ".rdb")
mrs_sqlite_file <- tempfile("mrs", fileext = ".sqlite")

mrs_sqlite_connect <- function() {
  DBI::dbConnect(RSQLite::SQLite(),
                 dbname = mrs_sqlite_file)
}

mrs_db <- mrs_db |>
  deploy(
    name = "mrs",
    connect = mrs_sqlite_connect,
    file = mrs_rdb_file
  )

}
\seealso{
\code{\link{star_database}}

Other star database deployment functions: 
\code{\link{cancel_deployment}()},
\code{\link{get_deployment_names}()},
\code{\link{load_star_database}()}
}
\concept{star database deployment functions}
