% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDatasets.R
\name{fitDatasets_lmer}
\alias{fitDatasets_lmer}
\alias{fitDatasets}
\alias{fitDatasets_lmer_bobyqa}
\alias{fitDatasets_lmer_Nelder_Mead}
\alias{fitDatasets_rlmer}
\alias{fitDatasets_rlmer_DAStau}
\alias{fitDatasets_rlmer_DAStau_lmerNoFit}
\alias{fitDatasets_rlmer_DASvar}
\alias{fitDatasets_rlmer_DAStau_noAdj}
\alias{fitDatasets_rlmer_DAStau_k_0_5}
\alias{fitDatasets_rlmer_DAStau_k_0_5_noAdj}
\alias{fitDatasets_rlmer_DAStau_k_2}
\alias{fitDatasets_rlmer_DAStau_k_2_noAdj}
\alias{fitDatasets_rlmer_DAStau_k_5}
\alias{fitDatasets_rlmer_DAStau_k_5_noAdj}
\alias{fitDatasets_heavyLme}
\alias{fitDatasets_lqmm}
\alias{fitDatasets_rlme}
\alias{fitDatasets_varComprob}
\alias{fitDatasets_varComprob_compositeTau}
\alias{fitDatasets_varComprob_compositeTau_OGK}
\alias{fitDatasets_varComprob_compositeTau_2SGS}
\alias{fitDatasets_varComprob_compositeS}
\alias{fitDatasets_varComprob_compositeS_OGK}
\alias{fitDatasets_varComprob_compositeS_2SGS}
\alias{fitDatasets_varComprob_S}
\alias{fitDatasets_varComprob_S_OGK}
\alias{fitDatasets_varComprob_S_2SGS}
\title{Fitting Functions}
\usage{
fitDatasets_lmer(datasets, control, label, postFit, datasetIndices = "all")

fitDatasets_lmer_bobyqa(datasets, postFit, datasetIndices = "all")

fitDatasets_lmer_Nelder_Mead(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer(
  datasets,
  method,
  tuningParameter,
  label,
  postFit,
  datasetIndices = "all",
  ...,
  init
)

fitDatasets_rlmer_DAStau(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_lmerNoFit(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DASvar(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_noAdj(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_k_0_5(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_k_0_5_noAdj(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_k_2(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_k_2_noAdj(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_k_5(datasets, postFit, datasetIndices = "all")

fitDatasets_rlmer_DAStau_k_5_noAdj(datasets, postFit, datasetIndices = "all")

fitDatasets_heavyLme(datasets, postFit, datasetIndices = "all")

fitDatasets_lqmm(datasets, postFit, datasetIndices = "all")

fitDatasets_rlme(datasets, postFit, datasetIndices = "all")

fitDatasets_varComprob(
  datasets,
  control,
  label,
  postFit,
  datasetIndices = "all"
)

fitDatasets_varComprob_compositeTau(datasets, postFit, datasetIndices = "all")

fitDatasets_varComprob_compositeTau_OGK(
  datasets,
  postFit,
  datasetIndices = "all"
)

fitDatasets_varComprob_compositeTau_2SGS(
  datasets,
  postFit,
  datasetIndices = "all"
)

fitDatasets_varComprob_compositeS(datasets, postFit, datasetIndices = "all")

fitDatasets_varComprob_compositeS_OGK(
  datasets,
  postFit,
  datasetIndices = "all"
)

fitDatasets_varComprob_compositeS_2SGS(
  datasets,
  postFit,
  datasetIndices = "all"
)

fitDatasets_varComprob_S(datasets, postFit, datasetIndices = "all")

fitDatasets_varComprob_S_OGK(datasets, postFit, datasetIndices = "all")

fitDatasets_varComprob_S_2SGS(datasets, postFit, datasetIndices = "all")
}
\arguments{
\item{datasets}{Datasets list to be used to generate datasets.}

\item{control}{a list (of correct class for the respective fitting function)
containing control parameters to be passed through.}

\item{label}{a string used to identify which fits have been created by which
function.}

\item{postFit}{a function, taking one argument, the resulting fit. This
makes it easy to add an additional step after fitting.}

\item{datasetIndices}{optional vector of dataset indices to fit, useful to
try only a few datasets instead of all of them.}

\item{method}{argument passed on to \code{\link{rlmer}}.}

\item{tuningParameter}{argument passed on to
\code{\link{extractTuningParameter}}.}

\item{...}{argument passed on to \code{\link{createRhoFunction}}.}

\item{init}{optional argument passed on to \code{\link{rlmer}}.}
}
\value{
list of fitted models. See also \code{\link{lapplyDatasets}} which
  is called internally.
}
\description{
Methods to fit various mixed effects estimators to all generated datasets.
}
\details{
Existing fitting functions are:

\code{fitDatasets_lmer}: Fits datasets using \code{\link[lme4]{lmer}}
  using its default options.

\code{fitDatasets_lmer_bobyqa}: Fits datasets using \code{\link[lme4]{lmer}} using
  the \code{bobyqa} optimizer.

\code{fitDatasets_lmer_Nelder_Mead}: Fits datasets using
  \code{\link[lme4]{lmer}} using the \code{Nelder Mead} optimizer.

\code{fitDatasets_rlmer}: Fits datasets using \code{\link{rlmer}}
  using a custom configuration. The argument 'tuningParameter' is passed to
  \code{\link{extractTuningParameter}}, details are documented there.

\code{fitDatasets_rlmer_DAStau}: Fits datasets using
  \code{\link{rlmer}} using method DAStau and \code{\link{smoothPsi}} for
  the rho functions. The tuning parameters are k = 1.345 for \code{rho.e}.
  For \code{rho.sigma.e}, the Proposal 2 variant is used using k = 2.28.
  The choices for \code{rho.b} and \code{rho.sigma.b} depend on whether the
  model uses a diagonal or a block diagonal matrix for Lambda. In the former
  case, the same psi functions and tuning parameters are use as for
  \code{rho.e} and \code{rho.sigma.b}. In the block diagonal case,
  \code{rho.b} and \code{rho.sigma.b} both use \code{\link{smoothPsi}} using
  a tuning parameter k = 5.14 (assuming blocks of dimension 2).

\code{fitDatasets_rlmer_DAStau_lmerNoFit}: Fits datasets using
  \code{\link{rlmer}} using the same configuration as
  \code{fitDatasets_rlmer_DAStau} except for that it is using
  \code{\link{lmerNoFit}} as initial estimator.

\code{fitDatasets_rlmer_DASvar}: Fits datasets using
  \code{\link{rlmer}} using method DASvar. The same rho functions and tuning
  parameters are used as for \code{fitDatasets_rlmer_DAStau}.

\code{fitDatasets_rlmer_DAStau_noAdj}: Fits datasets using
  \code{\link{rlmer}} using method DAStau. The same rho functions and tuning
  parameters are used as for \code{fitDatasets_rlmer_DAStau}, except for
  \code{rho.sigma.e} (and \code{rho.sigma.b} in the diagonal case) for which
  the Proposal 2 variant of \code{smoothPsi} using k = 1.345 is used.

\code{fitDatasets_rlmer_DAStau_k_0_5}: Fits datasets using
  \code{\link{rlmer}} using method DAStau. Use \code{\link{smoothPsi}}
  psi-function with tuning parameter \code{k = 0.5} for \code{rho.e} and
  \code{k = 1.47} for \code{rho.sigma.e}, the latter adjusted to reach the
  same asymptotic efficiency. In the diagonal case, the same are used for
  \code{rho.b} and \code{rho.sigma.b} as well. In the block-diagonal case,
  the tuning parameter \code{k = 2.17} is used for \code{rho.b} and
  \code{rho.sigma.b}. The tuning parameter is chosen to reach about the same
  asymptotic efficiency for theta as for the fixed effects.

\code{fitDatasets_rlmer_DAStau_k_0_5_noAdj}: Fits datasets using
  \code{\link{rlmer}} using method DAStau. Use \code{\link{smoothPsi}}
  psi-function with tuning parameter \code{k = 0.5} for \code{rho.e} and
  \code{rho.sigma.e}. In the diagonal case, the same are used for
  \code{rho.b} and \code{rho.sigma.b} as well. In the block-diagonal case,
  the tuning parameter \code{k = 2.17} is used for \code{rho.b} and
  \code{rho.sigma.b}. The tuning parameter is chosen to reach about the same
  asymptotic efficiency for theta as for the fixed effects.

\code{fitDatasets_rlmer_DAStau_k_2}: Fits datasets using
  \code{\link{rlmer}} using method DAStau. Use \code{\link{smoothPsi}}
  psi-function with tuning parameter \code{k = 2} for \code{rho.e} and
  \code{k = 2.9} \code{rho.sigma.e}, the latter adjusted to reach the same
  asymptotic efficiency. In the diagonal case, the same are used for
  \code{rho.b} and \code{rho.sigma.b} as well. In the block-diagonal case,
  the tuning parameter \code{k = 8.44} is used for \code{rho.b} and
  \code{rho.sigma.b}. The tuning parameter is chosen to reach about the same
  asymptotic efficiency for theta as for the fixed effects.

\code{fitDatasets_rlmer_DAStau_k_2_noAdj}: Fits datasets using
  \code{\link{rlmer}} using method DAStau. Use \code{\link{smoothPsi}}
  psi-function with tuning parameter \code{k = 2} for \code{rho.e} and
  \code{rho.sigma.e}. In the diagonal case, the same are used for
  \code{rho.b} and \code{rho.sigma.b} as well. In the block-diagonal case,
  the tuning parameter \code{k = 8.44} is used for \code{rho.b} and
  \code{rho.sigma.b}. The tuning parameter is chosen to reach about the same
  asymptotic efficiency for theta as for the fixed effects.

\code{fitDatasets_rlmer_DAStau_k_5}: Fits datasets using
  \code{\link{rlmer}} using method DAStau. Use \code{\link{smoothPsi}}
  psi-function with tuning parameter \code{k = 5} for \code{rho.e} and
  \code{k = 5.03} \code{rho.sigma.e}, the latter adjusted to reach the same
  asymptotic efficiency. In the diagonal case, the same are used for
  \code{rho.b} and \code{rho.sigma.b} as well. In the block-diagonal case,
  the tuning parameter \code{k = 34.21} is used for \code{rho.b} and
  \code{rho.sigma.b}. The tuning parameter is chosen to reach about the same
  asymptotic efficiency for theta as for the fixed effects.

\code{fitDatasets_rlmer_DAStau_k_5_noAdj}: Fits datasets using
  \code{\link{rlmer}} using method DAStau. Use \code{\link{smoothPsi}}
  psi-function with tuning parameter \code{k = 5} for \code{rho.e} and
  \code{rho.sigma.e}. In the diagonal case, the same are used for
  \code{rho.b} and \code{rho.sigma.b} as well. In the block-diagonal case,
  the tuning parameter \code{k = 34.21} is used for \code{rho.b} and
  \code{rho.sigma.b}. The tuning parameter is chosen to reach about the same
  asymptotic efficiency for theta as for the fixed effects.

\code{fitDatasets_heavyLme}: Fits datasets using
  \code{heavyLme} from package \code{heavy}. Additional
  required arguments are: \code{lmeFormula}, \code{heavyLmeRandom} and
  \code{heavyLmeGroups}. They are passed to the \code{formula},
  \code{random} and \code{groups} arguments of \code{heavyLme}.

\code{fitDatasets_lqmm}: Fits datasets using
  \code{\link[lqmm]{lqmm}} from package \code{lqmm}. Additional required
  arguments are: \code{lmeFormula}, \code{lqmmRandom}, \code{lqmmGroup} and
  \code{lqmmCovariance}. They are passed to the \code{formula},
  \code{random}, \code{groups} and \code{covariance} arguments of
  \code{lqmm}. \code{lqmmCovariance} is optional, if omitted \code{pdDiag}
  is used.

\code{fitDatasets_rlme}: Fits datasets using
  \code{\link[rlme]{rlme}} from package \code{rlme}.

\code{fitDatasets_varComprob}: Prototype method to fit datasets
  using \code{varComprob} from package
  \code{robustvarComp}. Additional required items in \code{datasets} are:
  \code{lmeFormula}, \code{groups}, \code{varcov} and \code{lower}. They are
  passed to the \code{fixed}, \code{groups}, \code{varcov} and \code{lower}
  arguments of \code{varComprob}. The running of this method produces many
  warnings of the form "passing a char vector to .Fortran is not portable"
  which are suppressed.

\code{fitDatasets_varComprob_compositeTau}: Fits datasets with the
  composite Tau method using \code{varComprob} from
  package \code{robustvarComp}. See \code{fitDatasets_varComprob} for
  additional details.

\code{fitDatasets_varComprob_compositeTau_OGK}: Similar to
  \code{fitDatasets_varComprob_compositeTau} but using \code{covOGK} as initial
  covariance matrix estimator.

\code{fitDatasets_varComprob_compositeTau_2SGS}: Similar to
  \code{fitDatasets_varComprob_compositeTau} but using \code{2SGS} as initial covariance
  matrix estimator.

\code{fitDatasets_varComprob_compositeS}: Similar to
  \code{fitDatasets_varComprob_compositeTau} but using method composite S.

\code{fitDatasets_varComprob_compositeS_OGK}: Similar to
  \code{fitDatasets_varComprob_compositeS} but using \code{covOGK} as
  initial covariance matrix estimator.

\code{fitDatasets_varComprob_compositeS_2SGS}: Similar to
  \code{fitDatasets_varComprob_compositeS} but using \code{2SGS} as initial
  covariance matrix estimator.

\code{fitDatasets_varComprob_S}: Similar to
  \code{fitDatasets_varComprob_compositeTau} but using method S and the
  Rocke psi-function.

\code{fitDatasets_varComprob_S_OGK}: Similar to
  \code{fitDatasets_varComprob_S} but using \code{covOGK} as initial
  covariance matrix estimator.

\code{fitDatasets_varComprob_S_2SGS}: Similar to
  \code{fitDatasets_varComprob_S} but using \code{2SGS} as initial
  covariance matrix estimator.
}
\examples{
  set.seed(1)
  oneWay <- generateAnovaDatasets(1, 1, 10, 4,
                                  lmeFormula = y ~ 1,
                                  heavyLmeRandom = ~ 1,
                                  heavyLmeGroups = ~ Var2,
                                  lqmmRandom = ~ 1,
                                  lqmmGroup = "Var2",
                                  groups = cbind(rep(1:4, each = 10), rep(1:10, 4)),
                                  varcov = matrix(1, 4, 4),
                                  lower = 0)
  fitDatasets_lmer(oneWay)
  ## call rlmer with custom arguments
  fitDatasets_rlmer_custom <- function(datasets) {
    return(fitDatasets_rlmer(datasets,
                             method = "DASvar",
                             tuningParameter = c(1.345, 2.28, 1.345, 2.28, 5.14, 5.14),
                             label = "fitDatasets_rlmer_custom"))
  }
  fitDatasets_rlmer_custom(oneWay)
}
\author{
Manuel Koller
}
