% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Show-Result.R
\name{plot.robustbetareg}
\alias{plot.robustbetareg}
\title{Diagnostic Plots for robustbetareg Objects}
\usage{
\method{plot}{robustbetareg}(x, ask = TRUE, ...)
}
\arguments{
\item{x}{fitted model object of class "\code{robustbetareg}".}

\item{ask}{logical. If "\code{TRUE}" the user is asked before each plot.}

\item{...}{graphical parameters passed to the \code{\link{plot}} function (see
\code{\link{par}}).}
}
\value{
\code{plot} method for \code{\link{robustbetareg}} objects returns
     several diagnostic plots.
}
\description{
Several types of standard diagnostic plots can be produced interactively,
involving different types of residuals.
}
\examples{
\donttest{
get(data("HIC", package = "robustbetareg"))
hic <- robustbetareg(HIC ~ URB + GDP | GDP,
                     data = HIC, alpha = 0.06)
}
}
\seealso{
\code{\link{robustbetareg}}, \code{\link{residuals.robustbetareg}},
     \code{\link{plotenvelope}}
}
