% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{nonmissing}
\alias{nonmissing}
\title{Determine which observations can be used for estimation}
\usage{
nonmissing(data, formula)
}
\arguments{
\item{data}{A dataframe.}

\item{formula}{A formula for the \code{\link[ivreg]{ivreg}} function, i.e. in
format \code{y ~ x1 + x2 | z1 + z2}.}
}
\value{
Returns a logical vector with the same length as the number of
observations in the data set that specifies whether an observation has any
missing values in any of y, x, or z variables. TRUE means not missing, FALSE
means at least one of these variables necessary for estimation is missing.
}
\description{
\code{nonmissing} takes a dataframe and a formula and determines which
observations can principally be used for the estimation of the 2SLS model
that is specified by the formula. Observations where any of the y, x, or z
variables are missing will be set to FALSE. While technically, fitted values
and residuals could be calculated for observations where only any of the
outside instruments is missing, this is often not desirable. This would cause
the sample on which the model is estimated to be different from the sample
on which the outliers are determined.
}
\keyword{internal}
