% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{isUndefined}
\alias{isUndefined}
\title{Tell if a string is undefined (NA or NULL); If yes, and its required by the mzQC standard,
we can raise an error.}
\usage{
isUndefined(s, ..., verbose = TRUE)
}
\arguments{
\item{s}{A string to be checked for NA/NULL}

\item{...}{More strings to be checked}

\item{verbose}{If TRUE and 's' is NULL/NA, will print the name of the variable which was passed in}
}
\description{
You can pass multiple strings, which are all checked.
If \strong{any} of them is undefined, the function returns TRUE
}
\examples{
isUndefined(NA)       ## TRUE
isUndefined(NULL)     ## TRUE
isUndefined(NA, NULL) ## TRUE
isUndefined("")       ## FALSE
isUndefined("", NA)   ## TRUE
isUndefined(NA, "")   ## TRUE
isUndefined(1)        ## FALSE
myVar = NA
isUndefined(myVar)    ## TRUE, with warning "Variable 'myVar' is NA/NULL!"

}
