% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{readH5AD}
\alias{readH5AD}
\alias{readH5ADMem}
\alias{readH5ADDelay}
\title{Read matrix from H5AD file}
\usage{
readH5AD(filename, layer, inMemory = TRUE, obs = FALSE)

readH5ADMem(filename, layer, obs = FALSE)

readH5ADDelay(filename, layer, obs = FALSE)
}
\arguments{
\item{filename}{Character string, path to the H5AD file.}

\item{layer}{Character string specifying the H5 path of raw count data to be
loaded. Use \code{'X'} for \code{adata.X}, \code{'raw/X'} for
\code{adata.raw.X}, or \code{'layers/layer_name'} for
\code{adata.layers['layer_name']}.}

\item{inMemory}{Logical, whether to load the data into memory. Default
\code{TRUE}. \code{FALSE} loads the data as a \code{DelayedArray} object.}

\item{obs}{Logical, whether to also load the cell metadata from
\code{adata.obs}. Default \code{FALSE}.}
}
\value{
When loaded in memory, a sparse matrix of class \code{dgCMatrix} will
be returned. When loaded in delayed mode, a \code{TENxMatrix} object will be
returned. If \code{obs = TRUE}, a list containing the matrix and the cell
metadata will be returned.
}
\description{
Read raw count matrix from H5AD file. By default, \code{readH5AD} load
specified layer into memory (\code{inMemory = TRUE}). To use LIGER in delayed
mode for handling large datasets, set \code{inMemory = FALSE} to load the
data as a \code{DelayedArray} object. Note that only CSR format is supported
for the matrix.
}
\details{
Currently, the only supported H5AD AnnData encoding versions are as follows:

\itemize{
\item{\code{adata.X}, \code{adata.raw.X}, or \code{adata.layers['layer']} -
csr_matrix 0.1.0}
\item{\code{adata.obs} and \code{adata.var} - dataframe 0.2.0}
\item{Categoricals in a data frame - categorical 0.2.0}
}

If users possess H5AD files encoded with older specification, please either
open an issue on GitHub or use R package 'anndata' to manually extract
information.
}
\examples{
tempH5AD <- tempfile(fileext = '.h5ad')
writeH5AD(pbmc, tempH5AD, overwrite = TRUE)
mat <- readH5AD(tempH5AD, layer = 'X')
delayMat <- readH5AD(tempH5AD, layer = 'X', inMemory = FALSE)
}
