% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{covMat.NoiseKriging}
\alias{covMat.NoiseKriging}
\alias{covMat,NoiseKriging,NoiseKriging-method}
\title{Compute Covariance Matrix of NoiseKriging Model}
\usage{
\method{covMat}{NoiseKriging}(object, x1, x2, ...)
}
\arguments{
\item{object}{An S3 NoiseKriging object.}

\item{x1}{Numeric matrix of input points.}

\item{x2}{Numeric matrix of input points.}

\item{...}{Not used.}
}
\value{
A matrix of the covariance matrix of the NoiseKriging model.
}
\description{
Compute Covariance Matrix of NoiseKriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X))

k <- NoiseKriging(y, (X/10)^2, X, "matern3_2")

x1 = runif(10)
x2 = runif(10)

covMat(k, x1, x2)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
