% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{read.lasheader}
\alias{read.lasheader}
\title{Read header from a .las or .laz file}
\usage{
read.lasheader(file)
}
\arguments{
\item{file}{filepath character string to the .las or .laz file}
}
\value{
A \code{list}
}
\description{
Reads header from .las or .laz files in format 1 to 4 according to LAS specifications and returns
a \code{list} labeled according to LAS specifications. See the ASPRS documentation for the
\href{http://www.asprs.org/wp-content/uploads/2019/07/LAS_1_4_r15.pdf}{LAS file format}.
}
\examples{
lazfile   <- system.file("extdata", "example.laz", package="rlas")
lasheader <- read.lasheader(lazfile)
}
\seealso{
Other rlas: 
\code{\link{write.las}()}
}
\concept{rlas}
