% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.r
\name{readlasdata}
\alias{readlasdata}
\title{Read data from a .las or .laz file}
\usage{
readlasdata(files, i = TRUE, r = TRUE, n = TRUE, d = TRUE, e = TRUE,
  c = TRUE, a = TRUE, u = TRUE, p = TRUE, rgb = TRUE, t = TRUE,
  filter = "", eb = 0)
}
\arguments{
\item{files}{filepath character string to the .las or .laz files}

\item{i}{logical. do you want to load the Intensity field? default: TRUE}

\item{r}{logical. do you want to load the ReturnNumber field? default: TRUE}

\item{n}{logical. do you want to load the NumberOfReturns field? default: TRUE}

\item{d}{logical. do you want to load the ScanDirectionFlag field? default: TRUE}

\item{e}{logical. do you want to load the EdgeOfFlightline field? default: TRUE}

\item{c}{logical. do you want to load the Classification field? default: TRUE}

\item{a}{logical. do you want to load the ScanAngle field? default: TRUE}

\item{u}{logical. do you want to load the UserData field? default: TRUE}

\item{p}{logical. do you want to load the PointSourceID field? default: TRUE}

\item{rgb}{logical. do you want to load R,G and B fields? default: TRUE}

\item{t}{logical. do you want to load gpstime fields? default: TRUE}

\item{filter}{character. filter data while reading the file (streaming filter) without
allocating any useless memory. (see Details).}

\item{eb}{integer vector. which extra byte attributes to load (see
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format specs}).
default is 0 meaning that all extra fields will be loaded. \code{c(1,3,7)} to load the first, the
third and the seventh extra byte attributes. None is \code{numeric(0)} or \code{NULL}.}
}
\value{
A \code{data.table}
}
\description{
(deprecated) Use \link{read.las}
}
\examples{
lazfile <- system.file("extdata", "example.laz", package="rlas")

lasdata <- readlasdata(lazfile)
lasdata <- readlasdata(lazfile, filter = "-keep_first")
lasdata <- readlasdata(lazfile, filter = "-drop_intensity_below 80")
}
