% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{create_forest_plot}
\alias{create_forest_plot}
\title{Create Forest Plot for Risk Difference Results}
\usage{
create_forest_plot(results, title = "Risk Differences", max_ci_width = 50, ...)
}
\arguments{
\item{results}{Results tibble from calc_risk_diff()}

\item{title}{Plot title (default: "Risk Differences")}

\item{max_ci_width}{Maximum CI width for display (default: 50)}

\item{...}{Additional arguments passed to ggplot}
}
\value{
A ggplot object
}
\description{
Creates a forest plot visualization of risk difference results,
automatically detecting stratification variables and creating appropriate labels.
}
\examples{
data(cachar_sample)
results <- calc_risk_diff(cachar_sample, "abnormal_screen", "areca_nut", strata = "residence")
create_forest_plot(results)

}
