% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup-attach.R
\name{attach_src}
\alias{attach_src}
\alias{attach_src.src_cfg}
\alias{attach_src.character}
\alias{detach_src}
\alias{setup_src_env}
\alias{setup_src_env.src_cfg}
\title{Data attach utilities}
\usage{
attach_src(x, ...)

\method{attach_src}{src_cfg}(x, assign_env = NULL, data_dir = src_data_dir(x), ...)

\method{attach_src}{character}(x, assign_env = NULL, data_dir = src_data_dir(x), ...)

detach_src(x)

setup_src_env(x, ...)

\method{setup_src_env}{src_cfg}(x, data_dir = src_data_dir(x), link_env = NULL, ...)
}
\arguments{
\item{x}{Data source to attach}

\item{...}{Forwarded to further calls to \code{attach_src()}}

\item{assign_env, link_env}{Environment in which the data source will become
available}

\item{data_dir}{Directory used to look for \code{\link[fst:fst]{fst::fst()}} files; \code{NULL} calls
\code{\link[=data_dir]{data_dir()}} using the source name as \code{subdir} argument}
}
\value{
Both \code{attach_src()} and \code{setup_src_env()} are called for side
effects and therefore return invisibly. While \code{attach_src()} returns \code{NULL},
\code{setup_src_env()} returns the newly created \code{src_env} object.
}
\description{
Making a dataset available to \code{ricu} consists of 3 steps: downloading
(\code{\link[=download_src]{download_src()}}), importing (\code{\link[=import_src]{import_src()}}) and attaching
(\code{\link[=attach_src]{attach_src()}}). While downloading and importing are one-time procedures,
attaching of the dataset is repeated every time the package is loaded.
Briefly, downloading loads the raw dataset from the internet (most likely
in \code{.csv} format), importing consists of some preprocessing to make the
data available more efficiently and attaching sets up the data for use by
the package.
}
\details{
Attaching a dataset sets up two types of S3 classes: a single \code{src_env}
object, containing as many \code{src_tbl} objects as tables are associated with
the dataset. A \code{src_env} is an environment with an \code{id_cfg} attribute, as
well as sub-classes as specified by the data source \code{class_prefix}
configuration setting (see \code{\link[=load_src_cfg]{load_src_cfg()}}). All \code{src_env} objects created
by calling \code{attach_src()} represent environments that are direct
descendants of the \code{data} environment and are bound to the respective
dataset name within that environment. For more information on \code{src_env} and
\code{src_tbl} objects, refer to \code{\link[=new_src_tbl]{new_src_tbl()}}.

If set up correctly, it is not necessary for the user to directly call
\code{attach_src()}. When the package is loaded, the default data sources (see
\code{\link[=auto_attach_srcs]{auto_attach_srcs()}}) are attached automatically. This default can be
controlled by setting as environment variable \code{RICU_SRC_LOAD} a comma
separated list of data source names before loading the library. Setting
this environment variable as\preformatted{Sys.setenv(RICU_SRC_LOAD = "mimic_demo,eicu_demo")
}

will change the default of loading both MIMIC-III and eICU, alongside the
respective demo datasets, as well as HiRID and AUMC, to just the two demo
datasets. For setting an environment variable upon startup of the R
session, refer to \code{\link[base:Startup]{base::.First.sys()}}.

Attaching a dataset during package namespace loading will both instantiate
a corresponding \code{src_env} in the \code{data} environment and for convenience
also assign this object into the package namespace, such that for example
the MIMIC-III demo dataset not only is available as
\verb{ricu::data::mimic_demo}, but also as \code{ricu::mimic_demo} (or if the package
namespace is attached, simply as \code{mimic_demo}). Dataset attaching using
\code{attach_src()} does not need to happen during namespace loading, but can be
triggered by the user at any time. If such a convenience link as described
above is desired by the user, an environment such as \code{.GlobalEnv} has to be
passed as \code{assign_env} to \code{attach_src()}.

Data sets are set up as \code{src_env} objects irrespectively of whether all (or
any) of the required data is available. If some (or all) data is missing,
the user is asked for permission to download in interactive sessions and an
error is thrown in non-interactive sessions. Downloading demo datasets
requires no further information but access to full-scale datasets (even
though they are publicly available) is guarded by access credentials (see
\code{\link[=download_src]{download_src()}}).

While \code{attach_src()} provides the main entry point, \code{src_env} objects are
instantiated by the S3 generic function \code{setup_src_env()} and the wrapping
function serves to catch errors that might be caused by config file parsing
issues as to not break attaching of the package namespace. Apart form this,
\code{attach_src()} also provides the convenience linking into the package
namespace (or a user-specified environment) described above.

A \code{src_env} object created by \code{setup_src_env()} does not directly contain
\code{src_tbl} objects bound to names, but rather an active binding (see
\code{\link[base:bindenv]{base::makeActiveBinding()}}) per table. These active bindings check for
availability of required files and evaluate to corresponding \code{src_tbl}
objects if these checks are passed and ask for user input otherwise. As
\code{src_tbl} objects are intended to be read-only, assignment is not possible
except for the value \code{NULL} which resets the internally cached \code{src_tbl}
that is created on first successful access.
}
\examples{
\dontrun{

Sys.setenv(RICU_SRC_LOAD = "")
library(ricu)

ls(envir = data)
exists("mimic_demo")

attach_src("mimic_demo", assign_env = .GlobalEnv)

ls(envir = data)
exists("mimic_demo")

mimic_demo

}

}
