% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfDROP2.R
\name{rfDROP2}
\alias{rfDROP2}
\alias{rfDROP2.default}
\alias{rfDROP2.formula}
\title{Decremental Reduction Optimization Procedure for Regression}
\usage{
\method{rfDROP2}{default}(x, y, k = 5, ...)

\method{rfDROP2}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{k}{an integer with the number of nearest neighbors to be used (default: 5).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata}, \link{summary.rfdata} and \link{plot.rfdata} methods.
}
\description{
Application of the rfDROP2 noise filtering method in a regression dataset.
}
\details{
\code{rfDROP2} tests the prediction of an edited dataset \code{S} over the original dataset \code{T}. 
The noise filter removes an instance \code{p} only if its exclusion does not increase the prediction error of its associates.
This is measured by comparing the accumulation of errors with and without \code{p} in the dataset.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- rfDROP2(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- rfDROP2(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
A. Arnaiz-González, J. Díez-Pastor, J. Rodríguez, C. García-Osorio,
\strong{Instance selection for regression: Adapting DROP.},
\emph{Neurocomputing}, 201:66-81, 2016.
\doi{https://doi.org/10.1016/j.neucom.2016.04.003}.

D. Randall, T. Martinez,
\strong{Instance pruning techniques.}
\emph{Machine Learning: Proceedings of the Fourteenth International Conference}, 404–411, 1997.
}
\seealso{
\code{\link{rfDROP3}}, \code{\link{regRNN}}, \code{\link{regCNN}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
