% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-ml.data.frame.R
\docType{methods}
\name{$<-,ml.data.frame-method}
\alias{$<-,ml.data.frame-method}
\title{Adds a new ml.data.frame field as a \link{ml.col.def-class}}
\usage{
\S4method{$}{ml.data.frame}(x, name) <- value
}
\arguments{
\item{x}{A ml.data.frame object}

\item{name}{Name of the new field}

\item{value}{The value for the new field. Typical a expression}
}
\value{
\link{ml.col.def-class} object
}
\description{
The fields  only exists within the object and are not created at the database side.
}
\examples{
\dontrun{
 library(rfml)
 locConn <- ml.connect()
 # create a ml.data.frame based on the iris data set
 mlIris <- as.ml.data.frame(locConn, iris, "iris")
 # create a field based on an existing
 mlIris$newField <- mlIris$Petal.Width
 # create a field based calculation on existing
 mlIris$newField2 <- mlIris$Petal.Width + mlIris$Petal.Length
 # create a field based on an previous created
 mlIris$newField3 <- mlIris$Petal.Width + 10
 mlIris$abs_width <- abs(mlIris$Petal.Width)
}
}

