% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Outline.R
\name{Outline}
\alias{Outline}
\title{Class containing basic information about flat outlines}
\description{
An Outline has contains the polygon describing the
  outline and an image associated with the outline.
}
\author{
David Sterratt
}
\section{Super class}{
\code{\link[retistruct:OutlineCommon]{retistruct::OutlineCommon}} -> \code{Outline}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{P}}{A N-by-2 matrix of points of the \code{Outline}
arranged in anticlockwise order}

\item{\code{scale}}{The length of one unit of \code{P} in the X-Y plane in arbitrary units}

\item{\code{scalez}}{The length of one unit of \code{P} in the Z-direction in arbitrary units}

\item{\code{units}}{String giving units of scaled P, e.g. \dQuote{um}}

\item{\code{gf}}{For each row of \code{P}, the index of \code{P} that
is next in the outline travelling anticlockwise (forwards)}

\item{\code{gb}}{For each row of \code{P}, the index of \code{P} that
is next in the outline travelling clockwise (backwards)}

\item{\code{h}}{For each row of \code{P}, the cut of that
point (which will be to itself initially)}

\item{\code{im}}{An image as a \code{raster} object}

\item{\code{dm}}{Depthmap, with same dimensions as \code{im}, which indicates
height of each pixel in Z-direction}

\item{\code{A.fragments}}{Areas of fragments}

\item{\code{dm.inferna.window.min}}{Minimum window size (in pixels) for inferring missing values in depthmaps}

\item{\code{dm.inferna.window.max}}{Minimum window size (in pixels) for inferring missing values in depthmaps}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Outline-new}{\code{Outline$new()}}
\item \href{#method-Outline-getImage}{\code{Outline$getImage()}}
\item \href{#method-Outline-replaceImage}{\code{Outline$replaceImage()}}
\item \href{#method-Outline-mapFragment}{\code{Outline$mapFragment()}}
\item \href{#method-Outline-mapPids}{\code{Outline$mapPids()}}
\item \href{#method-Outline-getDepth}{\code{Outline$getDepth()}}
\item \href{#method-Outline-addPoints}{\code{Outline$addPoints()}}
\item \href{#method-Outline-getFragmentPointIDs}{\code{Outline$getFragmentPointIDs()}}
\item \href{#method-Outline-getFragmentPoints}{\code{Outline$getFragmentPoints()}}
\item \href{#method-Outline-getFragment}{\code{Outline$getFragment()}}
\item \href{#method-Outline-getFragmentIDsFromPointIDs}{\code{Outline$getFragmentIDsFromPointIDs()}}
\item \href{#method-Outline-getFragmentIDs}{\code{Outline$getFragmentIDs()}}
\item \href{#method-Outline-getPoints}{\code{Outline$getPoints()}}
\item \href{#method-Outline-getPointsXY}{\code{Outline$getPointsXY()}}
\item \href{#method-Outline-getPointsScaled}{\code{Outline$getPointsScaled()}}
\item \href{#method-Outline-getRimSet}{\code{Outline$getRimSet()}}
\item \href{#method-Outline-getOutlineSet}{\code{Outline$getOutlineSet()}}
\item \href{#method-Outline-getOutlineLengths}{\code{Outline$getOutlineLengths()}}
\item \href{#method-Outline-addFeatureSet}{\code{Outline$addFeatureSet()}}
\item \href{#method-Outline-clone}{\code{Outline$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="clearFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-clearFeatureSets'><code>retistruct::OutlineCommon$clearFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSet"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSet'><code>retistruct::OutlineCommon$getFeatureSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSetTypes"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSetTypes'><code>retistruct::OutlineCommon$getFeatureSetTypes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getFeatureSets"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getFeatureSets'><code>retistruct::OutlineCommon$getFeatureSets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="OutlineCommon" data-id="getIDs"><a href='../../retistruct/html/OutlineCommon.html#method-OutlineCommon-getIDs'><code>retistruct::OutlineCommon$getIDs()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-new"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-new}{}}}
\subsection{Method \code{new()}}{
Construct an outline object. This sanitises the
  input points \code{P}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$new(
  fragments = list(),
  scale = NA,
  im = NULL,
  scalez = NA,
  dm = NULL,
  units = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fragments}}{A list of N-by-2 matrix of points for each fragment of the \code{Outline}}

\item{\code{scale}}{The length of one unit of \code{P} in arbitrary units}

\item{\code{im}}{The image as a \code{raster} object}

\item{\code{scalez}}{The length of one unit of \code{P} in the Z-direction in arbitrary units. If \code{NA}, the depthmap is ignored.}

\item{\code{dm}}{Depthmap, with same dimensions as \code{im}, which indicates
height of each pixel in Z-direction}

\item{\code{units}}{String giving units of scaled P, e.g. \dQuote{um}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getImage"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getImage}{}}}
\subsection{Method \code{getImage()}}{
Image accessor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getImage()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An image as a \code{raster} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-replaceImage"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-replaceImage}{}}}
\subsection{Method \code{replaceImage()}}{
Image setter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$replaceImage(im)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{im}}{An image as a \code{raster} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-mapFragment"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-mapFragment}{}}}
\subsection{Method \code{mapFragment()}}{
Map the point IDs of a \link{Fragment} on the
  point IDs of this Outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$mapFragment(fragment, pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fragment}}{\link{Fragment} to map}

\item{\code{pids}}{Point IDs in Outline of points in \link{Fragment}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-mapPids"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-mapPids}{}}}
\subsection{Method \code{mapPids()}}{
Map references to points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$mapPids(x, y, pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{References to point indices in source}

\item{\code{y}}{References to existing point indices in target}

\item{\code{pids}}{IDs of points in point register}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New references to point indices in target
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getDepth"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getDepth}{}}}
\subsection{Method \code{getDepth()}}{
Get depth of points P
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getDepth(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{matrix containing unscaled X-Y coordinates of points}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of unscaled Z coordinates of points P
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-addPoints"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-addPoints}{}}}
\subsection{Method \code{addPoints()}}{
Add points to the outline register of points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$addPoints(P, fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{2 or 3 column matrix of points to add}

\item{\code{fid}}{ID of fragment to which to add  the points}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The ID of each added point in the register. If points already
  exist a point will not be created in the register,
  but an ID will be returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getFragmentPointIDs"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getFragmentPointIDs}{}}}
\subsection{Method \code{getFragmentPointIDs()}}{
Get the point IDs in a fragment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getFragmentPointIDs(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{fragment id of the points}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of point IDs, i.e. indices of the rows in
  the matrices returned by \code{getPoints} and
  \code{getPointsScaled}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getFragmentPoints"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getFragmentPoints}{}}}
\subsection{Method \code{getFragmentPoints()}}{
Get the points in a fragment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getFragmentPoints(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{fragment id of the points}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of points
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getFragment"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getFragment}{}}}
\subsection{Method \code{getFragment()}}{
Get fragment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getFragment(fid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fid}}{Fragment ID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The  \code{\link{Fragment}} object with ID fid
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getFragmentIDsFromPointIDs"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getFragmentIDsFromPointIDs}{}}}
\subsection{Method \code{getFragmentIDsFromPointIDs()}}{
Get fragment IDs from point IDS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getFragmentIDsFromPointIDs(pids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pids}}{Vector of point IDs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The Fragment ID to which each point belongs
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getFragmentIDs"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getFragmentIDs}{}}}
\subsection{Method \code{getFragmentIDs()}}{
Get fragment IDs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getFragmentIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
IDs of all fragments
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getPoints"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getPoints}{}}}
\subsection{Method \code{getPoints()}}{
Get unscaled mesh points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getPoints(pids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pids}}{IDs of point to return}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix with columns \code{X}, \code{Y} and \code{Z}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getPointsXY"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getPointsXY}{}}}
\subsection{Method \code{getPointsXY()}}{
Get X-Y coordinates of unscaled mesh points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getPointsXY(pids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pids}}{IDs of point to return}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix with columns \code{X} and \code{Y}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getPointsScaled"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getPointsScaled}{}}}
\subsection{Method \code{getPointsScaled()}}{
Get scaled mesh points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getPointsScaled()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Matrix with columns \code{X} and \code{Y} which is
  exactly \code{scale} times the matrix returned by \code{getPoints}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getRimSet"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getRimSet}{}}}
\subsection{Method \code{getRimSet()}}{
Get set of points on rim
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getRimSet()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Vector of point IDs, i.e. indices of the rows in
  the matrices returned by \code{getPoints} and
  \code{getPointsScaled}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getOutlineSet"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getOutlineSet}{}}}
\subsection{Method \code{getOutlineSet()}}{
Get points on the edge of the outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getOutlineSet()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Vector of points IDs on outline
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-getOutlineLengths"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-getOutlineLengths}{}}}
\subsection{Method \code{getOutlineLengths()}}{
Get lengths of edges of the outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$getOutlineLengths()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Vector of lengths of edges connecting neighbouring points
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-addFeatureSet"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-addFeatureSet}{}}}
\subsection{Method \code{addFeatureSet()}}{
Add a \link{FeatureSet}, e.g. a \link{PointSet}
  or \link{LandmarkSet}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$addFeatureSet(fs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fs}}{\link{FeatureSet} to add}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Outline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
