\name{plot.cmp.rel}
\alias{plot.cmp.rel}


\title{Plot the cumulative incidence curves}

\description{
     Plot method for cmp.rel. Plots the probability of dying due to disease and due to population reasons
}
\usage{
	\method{plot}{cmp.rel}(x, main, curvlab, ylim=c(0, 1), xlim, wh=2, xlab="Time (days)",
	 ylab="Probability", lty=1:length(x), xscale=1,col=1, lwd=par('lwd'),
	 curves, conf.int, all.times=FALSE,...) 
}
\arguments{
\item{x}{a list, with each component representing one curve in the plot, output of the function \code{cmp.rel}.}
\item{main}{the main title for the plot.}
\item{curvlab}{Curve labels for the plot. Default is \code{names(x)}, or if that is missing, \code{1:nc}, where \code{nc} is the number of curves in \code{x}.}
\item{ylim}{yaxis limits for plot.}
\item{xlim}{xaxis limits for plot (default is 0 to the largest time in any of the curves).}
\item{wh}{if a vector of length 2, then the upper right coordinates of the legend; otherwise the legend is placed in the upper right corner of the plot.}
\item{xlab}{X axis label.}
\item{ylab}{y axis label.}
\item{lty}{vector of line types. Default \code{1:nc} (\code{nc} is the number of curves in \code{x}). For color displays, \code{lty=1}, \code{color=1:nc}, might be more appropriate. If \code{length(lty)<nc}, then \code{lty[1]} is used for all.}
\item{xscale}{Scale of the X axis. Default is in days (1).}
\item{col}{vector of colors. If \code{length(col)<nc}, then the \code{col[1]} is used for all.}
\item{lwd}{vector of line widths. If \code{length(lwd)<nc}, then \code{lwd[1]} is used for all.}
\item{curves}{Vector if integers, specifies which curves should be plotted. May take values \code{1:nc}, where \code{nc} is the number of curves in \code{x}. By default, all of the curves are plotted. }
\item{conf.int}{Vector if integers, specifies which confidence intervals should be plotted. May take values \code{1:nc}, where \code{nc} is the number of curves in \code{x}. By default, no confidence intervals are plotted. }
\item{all.times}{By default, the disease specific mortality estimate is plotted as a step function between event or censoring times. If set to \code{TRUE}, the graph is evaluated at all estimated times.}
\item{...}{additional arguments passed to the initial call of the plot function.}
}

\details{
By default, the graph is plotted as a step function for the cause specific mortality and as a piecewise linear function for the population mortality. It is evaluated at all event and censoring times even though it constantly changes also between these time points. 

If the argument \code{all.times} is set to \code{TRUE},  the plot is evaluated at all times that were used for numerical integration in the \code{cmp.rel} function (there, the default is set to daily intervals). If only specific time points are to be added, this should be done via argument \code{add.times} in \code{cmp.rel}.
}

\value{
No value is returned.
}


\examples{
data(slopop)
data(rdata)
#calculate the cumulative incidence curve
#note that the variable year is given in days since 01.01.1960 and that 
#age must be multiplied by 365 in order to be expressed in days.
fit <- cmp.rel(Surv(time,cens)~sex+ratetable(age=age*365,sex=sex,
      year=year),ratetable=slopop,data=rdata,tau=3652.41)
plot(fit,col=c(1,1,2,2),xscale=365.241,conf.int=c(1,3))
}


\seealso{
\code{rs.surv}
}

\keyword{survival}
