% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_bias}
\alias{part_bias}
\title{Calculate Partisan Bias}
\usage{
part_bias(plans, shp, dvote, rvote, v = 0.5)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{dvote}{Unqouted name of column in \code{shp} with total population.}

\item{rvote}{Unqouted name of column in \code{shp} with group population.}

\item{v}{vote share to calculate bias at. Numeric. Default is 0.5.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Partisan Bias
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_bias(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_bias(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Jonathan N. Katz, Gary King, and Elizabeth Rosenblatt. 2020.
Theoretical Foundations and Empirical Evaluations of Partisan Fairness in District-Based Democracies.
American Political Science Review, 114, 1, Pp. 164-178.
}
\concept{partisan}
