% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptype.R
\name{recipes_ptype}
\alias{recipes_ptype}
\title{Prototype of recipe object}
\usage{
recipes_ptype(x, ..., stage = "prep")
}
\arguments{
\item{x}{A \code{recipe} object.}

\item{...}{currently not used.}

\item{stage}{A single character. Must be one of \code{"prep"} or \code{"bake"}. See
details for more. Defaults to \code{"prep"}.}
}
\value{
A zero row tibble.
}
\description{
This helper function returns the prototype of the input data set expected by
the recipe object.
}
\details{
The returned ptype is a tibble of the data set that the recipe object is
expecting. The specifics of which columns depend on the \code{stage}.

At \code{\link[=prep]{prep()}} time, when \code{stage = "prep"}, the ptype is the data passed to
\code{\link[=recipe]{recipe()}}. The following code chunk represents a possible recipe scenario.
\code{recipes_ptype(rec_spec, stage = "prep")} and \code{recipes_ptype(rec_prep, stage = "prep")} both return a ptype tibble corresponding to \code{data_ptype}. This
information is used internally in \code{\link[=prep]{prep()}} to verify that \code{data_training} has
the right columns with the right types.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rec_spec <- recipe(outcome ~ ., data = data_ptype) \%>\%
  step_normalize(all_numeric_predictors()) \%>\%
  step_dummy(all_nominal_predictors())

rec_prep <- prep(rec_spec, training = data_training)
}\if{html}{\out{</div>}}

At \code{\link[=bake]{bake()}} time, when \code{stage = "bake"}, the ptype represents the data that
are required for \code{\link[=bake]{bake()}} to run.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data_bake <- bake(rec_prep, new_data = data_testing)
}\if{html}{\out{</div>}}

What this means in practice is that unless otherwise specified, everything
but outcomes and case weights are required. These requirements can be changed
with \code{\link[=update_role_requirements]{update_role_requirements()}}, and \code{recipes_ptype()} respects those
changes.

\code{recipes_ptype()} returns \code{NULL} on recipes created prior to version 1.1.0.

Note that the order of the columns aren't guaranteed to align with
\code{data_ptype} as the data internally is ordered according to roles.
}
\examples{
training <- tibble(
  y = 1:10,
  id = 1:10,
  x1 = letters[1:10],
  x2 = factor(letters[1:10]),
  cw = hardhat::importance_weights(1:10)
)
training

rec_spec <- recipe(y ~ ., data = training)

# outcomes and case_weights are not required at bake time
recipes_ptype(rec_spec, stage = "prep")
recipes_ptype(rec_spec, stage = "bake")

rec_spec <- recipe(y ~ ., data = training) \%>\%
  update_role(x1, new_role = "id")

# outcomes and case_weights are not required at bake time
# "id" column is assumed to be needed
recipes_ptype(rec_spec, stage = "prep")
recipes_ptype(rec_spec, stage = "bake")

rec_spec <- recipe(y ~ ., data = training) \%>\%
  update_role(x1, new_role = "id") \%>\%
  update_role_requirements("id", bake = FALSE)

# update_role_requirements() is used to specify that "id" isn't needed
recipes_ptype(rec_spec, stage = "prep")
recipes_ptype(rec_spec, stage = "bake")

}
\seealso{
\link{developer_functions} \link{recipes_ptype_validate}
}
\keyword{internal}
