% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterise_stream.R
\name{rasterise_stream}
\alias{rasterise_stream}
\title{Turn a shapefile of stream edges into a raster}
\usage{
rasterise_stream(streams, out, overwrite = FALSE, max_memory = 300, ...)
}
\arguments{
\item{streams}{A file name for a shapefile of stream edges in the current GRASS mapset.}

\item{out}{The filename of the output.}

\item{overwrite}{A logical indicating whether the output is allowed to overwrite existing files. Defaults to \code{FALSE}.}

\item{max_memory}{Max memory used in memory swap mode (MB). Defaults to \code{300}.}

\item{...}{Additional arguments to \code{v.to.rast}.}
}
\value{
Nothing. A file will be written to \code{out}. Note that \code{out} can be a full file path to any location in your file system. A raster with the name \code{basename(out)} will be written to the current GRASS mapset.
}
\description{
Given a shapefile of lines representing the channels of a stream network, this function will return a rasterised version of the shapefile. The raster will have the parameters of the current GRASS mapset.
}
\examples{
# Will only run if GRASS is running
if(check_running()){
# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")
stream_shp <- system.file("extdata", "streams.shp", package = "rdwplus")

# Set environment parameters and import data to GRASS
set_envir(dem)
vector_to_mapset(vectors = stream_shp)

# Create rasterised stream
rasterise_stream("streams", "streams_rast.tif", overwrite = TRUE)

# Plot
plot_GRASS("streams_rast.tif")

}
}
