% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{available_datasets}
\alias{available_datasets}
\title{Create a data frame of datasets that your log in can download}
\usage{
available_datasets(
  config,
  datasets_api_results = NULL,
  surveys_api_results = NULL
)
}
\arguments{
\item{config}{Object of class `rdhs_config` as produced by `read_rdhs_config`
that must contain a valid `email`, `project` and `password`.}

\item{datasets_api_results}{Data.table for the api results for the datasets
  endpoint. Default = NULL and
generated by default if not declared.}

\item{surveys_api_results}{Data.table for the api results for the surveys
  endpoint. Default = NULL and
generated by default if not declared.}
}
\value{
Returns \code{"data.frame"} of length 14:
\itemize{
      \item{"FileFormat"}
      \item{"FileSize"}
      \item{"DatasetType"}
      \item{"SurveyNum"}
      \item{"SurveyId"}
      \item{"FileType"}
      \item{"FileDateLastModified"}
      \item{"SurveyYearLabel"}
      \item{"SurveyType"}
      \item{"SurveyYear"}
      \item{"DHS_CountryCode"}
      \item{"FileName"}
      \item{"CountryName"}
      \item{"URLS"}
      }
}
\description{
DHS datasets that can be downloaded
}
\note{
Inspiration for function to
  \url{https://github.com/ajdamico/lodown/blob/master/R/dhs.R}
}
