% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrameHelpers.R
\name{pixelArea}
\alias{pixelArea}
\title{Area of a HEALPix pixel}
\usage{
pixelArea(nsideObject)
}
\arguments{
\item{nsideObject}{\code{\link{CMBDataFrame}}, a
\code{\link{HPDataFrame}}, or an integer
giving the nside parameter.}
}
\value{
the area of a single HEALPix pixel
at the \code{nside} resolution of \code{nsideObject}
}
\description{
Get the area of a single HEALPix pixel
}
\examples{
## First download the map
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# pixelArea(df)

df1 <- CMBDataFrame(nside = 64,
                    coords = "cartesian",
                    ordering = "nested")
pixelArea(df1)

}
