% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareLM.r
\name{compareLM}
\alias{compareLM}
\title{Compare fit statistics for lm models}
\usage{
compareLM(fits, ...)
}
\arguments{
\item{fits}{A series of model object names, separated by commas.}

\item{...}{Other arguments passed to \code{list}.}
}
\value{
A list of two objects: The series of model calls, and a data 
        frame of statistics for each model.
}
\description{
Produces a table of fit statistics for multiple lm models.
}
\details{
Produces a table of fit statistics for multiple lm models: 
          AIC, AICc, BIC, p-value, R-squared, and adjusted R-squared.
          
          Smaller values for AIC, AICc, and BIC indicate a better balance
          of goodness-of-fit of the model and the complexity of the
          model. The goal is to find a model that adequately explains the 
          data without having too many terms.
          
          BIC tends to choose models with fewer parameters relative to AIC.
          
          In the table, \code{Shapiro.W} and \code{Shapiro.p} are the
          W statistic and p-value for the Shapiro-Wilks test on the residuals
          of the model.
          
          For comparisons with AIC, etc., to be valid, both models must
          have the same data, without transformations, use the same 
          dependent variable, and be fit with the same method.
          They do not need to be nested.
}
\examples{
### Compare among polynomial models
data(BrendonSmall)
BrendonSmall$Calories = as.numeric(BrendonSmall$Calories)

BrendonSmall$Calories2 = BrendonSmall$Calories * BrendonSmall$Calories
BrendonSmall$Calories3 = BrendonSmall$Calories * BrendonSmall$Calories * 
                         BrendonSmall$Calories
BrendonSmall$Calories4 = BrendonSmall$Calories * BrendonSmall$Calories * 
                         BrendonSmall$Calories * BrendonSmall$Calories
model.1 = lm(Sodium ~ Calories, data = BrendonSmall)
model.2 = lm(Sodium ~ Calories + Calories2, data = BrendonSmall)
model.3 = lm(Sodium ~ Calories + Calories2 + Calories3, data = BrendonSmall)
model.4 = lm(Sodium ~ Calories + Calories2 + Calories3 + Calories4,
             data = BrendonSmall)
compareLM(model.1, model.2, model.3, model.4)

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/I_10.html}
            \url{http://rcompanion.org/rcompanion/e_05.html}
}
\seealso{
\code{\link{compareGLM}}
}
\concept{
AIC BIC AICc p-value R-squared
}

