% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentage_of_clipped_highlights.R
\name{percentage_of_clipped_highlights}
\alias{percentage_of_clipped_highlights}
\title{Percentage of clipped highlights}
\usage{
percentage_of_clipped_highlights(r, m)
}
\arguments{
\item{r}{Single-layer object from the \linkS4class{SpatRaster}.}

\item{m}{\linkS4class{SpatRaster}. A mask. For hemispherical photographs,
check \code{\link[=mask_hs]{mask_hs()}}.}
}
\value{
Numeric vector of lenght one.
}
\description{
Wrapper function for \code{\link[terra:freq]{terra::freq()}}
}
\examples{
r <- read_caim()$Blue
z <- zenith_image(ncol(r), lens())
m <- !is.na(z)
percentage_of_clipped_highlights(r, m)
r <- normalize(r, 0, 1000, TRUE)
percentage_of_clipped_highlights(r, m)
}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{read_bin}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
