% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_qtree.R
\name{polar_qtree}
\alias{polar_qtree}
\title{Quad-tree segmentation in the polar space}
\usage{
polar_qtree(r, z, a, scale_parameter = 0.2)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{scale_parameter}{Numeric vector of length one. Quad-tree is a top-down
method. This parameter controls the stopping condition. Therefore, it
allows controlling the size of the resulting segments. Ultimately, segments
sizes will depend on both this parameter and the heterogeneity of \code{r}.}
}
\value{
A single layer image of the class \linkS4class{SpatRaster} with
  integer values.
}
\description{
The quad-tree segmentation algorithm is a top-down process that makes
recursive divisions in four equal parts until a condition is satisfied and
stops locally. The usual implementation of the quad-tree algorithm is
based on the raster structure and this is why the result are squares of
different sizes. This method implements the quad-tree segmentation in a polar
space, so the segments are shaped like windshields, though some of them will
look elongated in height. The pattern is two opposite and converging straight
sides and two opposite and parallel curvy sides.
}
\details{
The algorithm splits segments of 30 degrees resolution into four sub-segments
and calculates the standard deviation of the pixels from \code{r} delimited
by each of those segments. The splitting process stops locally if the sum of
the standard deviation of the sub-segments minus the standard deviation of
the parent segment (named \emph{delta}) is less or equal than the
\code{scale_parameter}. If \code{r} has more than one layer, \emph{delta} is
calculated separately and \emph{delta} mean is used to evaluate the stopping
condition.
}
\examples{
\dontrun{
caim <- read_caim()
plot(caim)
caim <- normalize(caim, 0, 255)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
seg <- polar_qtree(caim, z, a)
plot(seg)
plot(extract_feature(caim$Blue, seg))
}
}
\seealso{
Other Segmentation Functions: 
\code{\link{chessboard}()},
\code{\link{mask_hs}()},
\code{\link{mask_sunlit_canopy}()},
\code{\link{qtree}()},
\code{\link{rings_segmentation}()},
\code{\link{sectors_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation Functions}
