% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azimuth_image.R
\name{azimuth_image}
\alias{azimuth_image}
\title{Azimuth image}
\usage{
azimuth_image(z)
}
\arguments{
\item{z}{\linkS4class{RasterLayer} built with
\code{\link{zenith_image}}.}
}
\value{
An object of class \linkS4class{RasterLayer} of azimuth angles
  in degrees. North (0º) is pointing up as in maps, but East (90º) and West
  (270º) are flipped respect to maps. To understand why is that, take two
  flash-card size pieces of paper. Put one on a table in front of you and
  draw on it a compass rose. Take the other and hold it with your arms
  extended over your head, and, following the directions of the compass rose
  in front of you, draw another compass rose in the paper side that face
  down. Then, put it down and compare both compass roses.
}
\description{
Build a single layer image with azimuth angles as pixel values.
}
\examples{
z <- zenith_image(1490, lens("Nikon_FCE9"))
azimuth_image(z)
plot(z)
}
\seealso{
Other Lens functions: 
\code{\link{calc_diameter}()},
\code{\link{calc_zenith_raster_coordinates}()},
\code{\link{calibrate_lens}()},
\code{\link{expand_noncircular}()},
\code{\link{lens}()},
\code{\link{reproject_to_equidistant}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens functions}
