% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_map.r
\name{taxa_map}
\alias{taxa_map}
\title{Map OTUs names to taxa names at a given rank.}
\usage{
taxa_map(
  biom,
  rank = NULL,
  taxa = Inf,
  unc = "singly",
  lineage = FALSE,
  other = FALSE
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{rank}{When \code{NULL}, the entire biom$taxonomy data.frame is returned,
transformed as per \code{unc}. Alternatively, a single taxonomic rank
(rank name or integer position in \code{biom$ranks}) which returns a named
character vector for mapping OTUs to taxa names.}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{lineage}{Include all ranks in the name of the taxa. For instance,
setting to \code{TRUE} will produce
\verb{Bacteria; Actinobacteria; Coriobacteriia; Coriobacteriales}.
Otherwise the taxa name will simply be \code{Coriobacteriales}. You
want to set this to TRUE when \code{unc = "asis"} and you have taxa
names (such as \emph{Incertae_Sedis}) that map to multiple higher
level ranks. Default: \code{FALSE}}

\item{other}{Sum all non-itemized taxa into an "Other" taxa. When
\code{FALSE}, only returns taxa matched by the \code{taxa}
argument. Specifying \code{TRUE} adds "Other" to the returned set.
A string can also be given to imply \code{TRUE}, but with that
value as the name to use instead of "Other".
Default: \code{FALSE}}
}
\value{
A tibble data.frame when \code{rank=NULL}, or a character vector named
with the OTU names.
}
\description{
Map OTUs names to taxa names at a given rank.
}
\examples{
    library(rbiom)
    library(dplyr, warn.conflicts = FALSE)
    
    # In $taxonomy, .otu is the first column (like a row identifier)  -----
    hmp50$taxonomy \%>\% head(4)
    
    # In taxa_map, .otu is the last column (most precise rank)  -----------
    taxa_map(hmp50) \%>\% head(4)
    
    # Generate an OTU to Genus mapping  -----------------------------------
    taxa_map(hmp50, "Genus") \%>\% head(4)
    
    # Sometimes taxonomic names are incomplete ----------------------------
    otus <- c('GemAsacc', 'GcbBacte', 'Unc58411')
    taxa_map(hmp50, unc = "asis") \%>\% filter(.otu \%in\% otus) \%>\% select(Phylum:.otu)
    
    # rbiom can replace them with unique placeholders ---------------------
    taxa_map(hmp50, unc = "singly") \%>\% filter(.otu \%in\% otus) \%>\% select(Class:.otu)
    
    # Or collapse them into groups ----------------------------------------
    taxa_map(hmp50, unc = "grouped") \%>\% filter(.otu \%in\% otus) \%>\% select(Class:Genus)

}
\seealso{
\code{pull.rbiom()}
}
\concept{taxonomy}
