% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.r
\name{slice_metadata}
\alias{slice_metadata}
\alias{slice.rbiom}
\alias{slice_head.rbiom}
\alias{slice_tail.rbiom}
\alias{slice_min.rbiom}
\alias{slice_max.rbiom}
\alias{slice_sample.rbiom}
\title{Subset to a specific number of samples.}
\usage{
\method{slice}{rbiom}(.data, ..., .by = NULL, .preserve = FALSE, clone = TRUE)

\method{slice_head}{rbiom}(.data, n, prop, by = NULL, clone = TRUE, ...)

\method{slice_tail}{rbiom}(.data, n, prop, by = NULL, clone = TRUE, ...)

\method{slice_min}{rbiom}(
  .data,
  order_by,
  n,
  prop,
  by = NULL,
  with_ties = TRUE,
  na_rm = FALSE,
  clone = TRUE,
  ...
)

\method{slice_max}{rbiom}(
  .data,
  order_by,
  n,
  prop,
  by = NULL,
  with_ties = TRUE,
  na_rm = FALSE,
  clone = TRUE,
  ...
)

\method{slice_sample}{rbiom}(
  .data,
  n,
  prop,
  by = NULL,
  weight_by = NULL,
  replace = FALSE,
  clone = TRUE,
  ...
)
}
\arguments{
\item{.data}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.}

\item{...}{For \code{slice()}, integer row indexes. For other \verb{slice_*()}
functions, not used. See \code{\link[dplyr:slice]{dplyr::slice()}}.}

\item{.by, by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}

\item{clone}{Create a copy of \code{biom} before modifying. If \code{FALSE}, \code{biom}
is modified in place as a side-effect. See \link[=speed]{speed ups} for
use cases. Default: \code{TRUE}}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group
(or \code{prop > 1}), the result will be silently truncated to the group size.
\code{prop} will be rounded towards zero to generate an integer number of
rows.

A negative value of \code{n} or \code{prop} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows; \code{prop = -0.25} with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{order_by}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variable or
function of variables to order by. To order by multiple variables, wrap
them in a data frame or tibble.}

\item{with_ties}{Should ties be kept together? The default, \code{TRUE},
may return more rows than you request. Use \code{FALSE} to ignore ties,
and return the first \code{n} rows.}

\item{na_rm}{Should missing values in \code{order_by} be removed from the result?
If \code{FALSE}, \code{NA} values are sorted to the end (like in \code{\link[dplyr:arrange]{arrange()}}), so
they will only be included if there are insufficient non-missing values to
reach \code{n}/\code{prop}.}

\item{weight_by}{<\code{\link[rlang:args_data_masking]{data-masking}}> Sampling
weights. This must evaluate to a vector of non-negative numbers the same
length as the input. Weights are automatically standardised to sum to 1.}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without
(\code{FALSE}, the default) replacement.}
}
\value{
An \link[=rbiom_objects]{rbiom object}.
}
\description{
Subset to a specific number of samples.
}
\examples{
    library(rbiom)
    
    # The last 3 samples in the metadata table.
    biom <- slice_tail(hmp50, n = 3)
    biom$metadata
    
    # The 3 oldest subjects sampled.
    biom <- slice_max(hmp50, Age, n = 3)
    biom$metadata
    
    # Pick 3 samples at random.
    biom <- slice_sample(hmp50, n = 3)
    biom$metadata

}
\seealso{
Other transformations: 
\code{\link{modify_metadata}},
\code{\link{rarefy}()},
\code{\link{rarefy_cols}()},
\code{\link{subset}()},
\code{\link{with}()}
}
\concept{transformations}
