% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmall.R
\name{rmall}
\alias{rmall}
\title{Random Mallows generation.}
\usage{
rmall(I, pi0, theta, R = NULL)
}
\arguments{
\item{I}{A numeric entry indicating the number of observations to be drawn, i.e., the number of judges
providing rankings and ratings.}

\item{pi0}{A vector specifying the consensus (modal probability) ranking; should be used only for tie-breaking
equal values in \code{p}.}

\item{theta}{A numeric entry specifying the Mallows scale parameter.}

\item{R}{A numeric entry specifying the length of the rankings to be drawn. When \code{R<=length(p)}, partial
rankings are drawn by definition.}
}
\value{
A matrix of rankings (orderings) with one row per judge.
}
\description{
This function randomly generates rankings from a Mallows distribution.
}
\examples{
rmall(I=5,pi0=1:5,theta=1,R=3)
rmall(I=5,pi0=1:3,theta=.5,R=c(1,1,1,1,3))
rmall(I=5,pi0=1:3,theta=.5)

}
