% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Report.r
\name{MVP.Hist}
\alias{MVP.Hist}
\title{Phenotype distribution histogram}
\usage{
MVP.Hist(
  phe,
  col = c("dodgerblue4", "olivedrab4", "violetred", "darkgoldenrod1", "purple4"),
  breakNum = 15,
  memo = NULL,
  outpath = getwd(),
  test.method = "auto",
  file.type = "pdf",
  file.output = TRUE,
  dpi = 300
)
}
\arguments{
\item{phe}{phenotype data}

\item{col}{The color vector of the histogram. If the number of colors is 
less than break.n, the color will be reused. If the number of colors is 
greater than break.n, only the previous break.n colors will be used.}

\item{breakNum}{the number of cells for the histogram. The default value 
is 15.}

\item{memo}{Character. A text marker on output files}

\item{outpath}{Effective only when file.output = TRUE, determines the path of the output file}

\item{test.method}{The method used to test the normal distribution. The options are "auto", 
"Shapiro-Wilk", "Kolmogorov-Smirnov", and NULL. When set to "auto", "Shapiro- Wilk" method,
"Kolmogorov-Smirnov" method will be used when it is greater than 5000, and it will not be 
tested when set to NULL.}

\item{file.type}{A string or NULL is used to determine the type of output 
file. Can be "jpg", "pdf", "tiff". If it is NULL, it will use 
\code{\link[grDevices:dev]{dev.new()}} to create a new graphics device 
in the current environment, which may be RStudioGD or the default 
device of the system.}

\item{file.output}{Logical value. If TRUE, the figures will be generated.}

\item{dpi}{The resolution of the image, specifying how many pixels 
per inch.}
}
\value{
Output file:
MVP.Phe_Distribution.<trait>.<type>
}
\description{
Phenotype distribution histogram
}
\examples{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phe <- read.table(phePath, header=TRUE)

MVP.Hist(phe, file.output = FALSE)

}
