/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.devsmart.ubjson.UBArray;
import com.devsmart.ubjson.UBValue;

public class UBJSONUtil {
    private UBJSONUtil() {
    }

    public static boolean[] toBooleanArray(UBValue value) {
        UBArray array = value.asArray();
        if (array.isBool()) {
            return array.asBoolArray();
        }
        boolean[] result = new boolean[array.size()];
        for (int i = 0; i < result.length; ++i) {
            UBValue element = array.get(i);
            if (element.isBool()) {
                result[i] = element.asBool();
                continue;
            }
            if (element.isNumber()) {
                result[i] = element.asInt() == 1;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static int[] toIntArray(UBValue value) {
        UBArray array = value.asArray();
        if (array.isInteger()) {
            return array.asInt32Array();
        }
        int[] result = new int[array.size()];
        for (int i = 0; i < result.length; ++i) {
            UBValue element = array.get(i);
            result[i] = element.asInt();
        }
        return result;
    }

    public static float[] toFloatArray(UBValue value) {
        UBArray array = value.asArray();
        if (array.isNumber()) {
            return array.asFloat32Array();
        }
        float[] result = new float[array.size()];
        for (int i = 0; i < result.length; ++i) {
            UBValue element = array.get(i);
            result[i] = element.asFloat32();
        }
        return result;
    }

    public static String[] toStringArray(UBValue value) {
        UBArray array = value.asArray();
        if (array.isString()) {
            return array.asStringArray();
        }
        String[] result = new String[array.size()];
        for (int i = 0; i < result.length; ++i) {
            UBValue element = array.get(i);
            result[i] = element.asString();
        }
        return result;
    }
}

