% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ll.R
\name{ll}
\alias{ll}
\title{List Object Aliases}
\usage{
ll(
  pos = 1,
  pattern,
  order_by = "size",
  decreasing = order_by \%in\% c("size", "rows", "columns")
)
}
\arguments{
\item{pos}{specifies the environment as a position in the search list}

\item{pattern}{an optional regular expression.  Only names matching
\code{pattern} are returned.  \code{\link[utils]{glob2rx}} can be used to
convert wildcard patterns to regular expressions.}

\item{order_by}{a character, order the results by \dQuote{object},
\dQuote{size} (default), \dQuote{class}, \dQuote{rows}, or \dQuote{columns}.}

\item{decreasing}{logical, defaults to \code{TRUE}, decreasing order? passed
to \code{\link[base]{order}}.}
}
\value{
a data.frame with columns
\itemize{
 \item object: name of the object
 \item class: class, or mode if class is not present, of the object
 \item size: approximate size, in bytes, of the object in memory
 \item rows: number of rows for data.frames or matrices, or the number of
 elements for a list like structure
 \item columns: number of columns for data.frames or matrices
}
}
\description{
Aliases for \code{\link[base]{ls}} providing additional details.
}
\examples{
# View your current workspace
\dontrun{
ls()
ll()
}

# View another environment
e <- new.env()
ll(e)

e$fit <- lm(mpg ~ wt, mtcars)
e$fit2 <- lm(mpg ~ wt + am + vs, data = mtcars)
e$x <- rnorm(1e5)
e$y <- runif(1e4)
e$z <- with(e, x * y)
e$w <- sum(e$z)

ls(e)
ll(e)

}
\references{
The basis for this work came from a Stack Overflow posting:
\url{https://stackoverflow.com/q/1358003/1104685}
}
\seealso{
\code{\link[base]{ls}}
}
